package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.entity.PersonExamRecord;
import com.yeejoin.precontrol.common.service.IPersonExamRecordService;
import com.yeejoin.precontrol.common.vo.PersonExamRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * 考试记录表
 *
 * @author duanwei
 * @date 2021-02-23
 */
@RestController
@Api(tags = "考试记录表Api")
@RequestMapping(value = "/person-exam-record", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class PersonExamRecordController {

	@Autowired
	IPersonExamRecordService iPersonExamRecordService;

	/**
	 * 新增考试记录表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增考试记录表", notes = "新增考试记录表")
	public boolean savePersonExamRecord(HttpServletRequest request, @RequestBody PersonExamRecord personExamRecord) {
		return iPersonExamRecordService.save(personExamRecord);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iPersonExamRecordService.removeById(id);
	}

	/**
	 * 修改考试记录表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改考试记录表", notes = "修改考试记录表")
	public boolean updateByIdPersonExamRecord(HttpServletRequest request,
			@RequestBody PersonExamRecord personExamRecord) {
		return iPersonExamRecordService.updateById(personExamRecord);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public PersonExamRecord selectById(HttpServletRequest request, @PathVariable Long id) {
		return iPersonExamRecordService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<PersonExamRecordVo> listPage(CommonPageableDto pageable, PersonExamRecordVo personExamRecordVo) {
		Page<PersonExamRecordVo> page = iPersonExamRecordService.pageInfo(pageable, personExamRecordVo);
		return page;
	}
}
