package com.yeejoin.amos.boot.module.elevator.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDtoNew;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorMessageDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorWlInfoDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.Elevator;
import com.yeejoin.amos.boot.module.elevator.api.entity.TzBaseEnterpriseInfo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
*  Mapper 接口
*
* @author tb
* @date 2021-06-01
*/
public interface ElevatorMapper extends BaseMapper<Elevator> {

    List<ElevatorWlInfoDto>  queryElevatorList(String address,
                                               String registerCode,
                                               Integer rescueCode,
                                               String type,
                                               Integer dealStatus,
                                               Long sequenceNbr,
                                               int current, int size);

    List<ElevatorWlInfoDto>  queryElevatorListDetails(
            Long sequenceNbr
    );

    int  queryElevatorListCount();

    List<ElevatorDto> selectExportData(@Param("ids") List<String> ids);
    @Select("select * from tcb_elevator where address like concat('%',#{address},'%')")
    List<ElevatorDto> getAddressList(String address);

    List<ElevatorMessageDto> getAddressListNew(@Param("address") String address);


    Page<Map<String, Object>> selectElevators(@Param("page") Page<Map<String, Object>> page, @Param("dto") ElevatorDto dto);

    List<ElevatorDtoNew> selectExportDataNew(@Param("dto") ElevatorDto dto, @Param("ids")List<String> ids);


    Map<String, Object> selectByRecord(@Param("record") String record);

    Map<String, Object> selectFiles(@Param("record") String record);

    Map<String, Object> selectRegisterFiles(@Param("record") String record);

    Map<String, Object> selectMaintenanceInspectionFiles(@Param("record") String record);

    Map<String,Object> selectElevator(@Param("elevator") Elevator elevator);

    List<Map<String,Object>> selectElevatorList(@Param("elevator") Elevator elevator);

    List<Map<String, Object>> selectElevatorEsList(int pageNum, int pageSize);

    Integer selectUseInfoCount();

    List<Map<String, Object>> selectMtByAlertId(String sequenceNbr);


    Map<String, Object> selectMainUnitMessage(String sequenceNbr);

    Map<String, Object> selectUseUnitByAlertId(String sequenceNbr);

    /**
     * 查询未同步到es的电梯：已纳管且有96333且有使用登记证
     * @param page 分页对象
     * @return 电梯结果分页对象
     */
    Page<Map<String, Object>> selectElevatorOfIntoManage(Page<Map<String, Object>> page);
}
