package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@Group(value = "equip_factory_info")
public class EquipFactoryChangeDataDto extends BaseChangeDataDto {

    @FieldDisplayDefine(value = "制造单位统一社会信用代码")
    private String produceUnitCreditCode;

    @FieldDisplayDefine(value = "制造单位名称")
    private String produceUnitName;

    @FieldDisplayDefine(value = "制造许可编号")
    private String produceLicenseNum;

    @FieldDisplayDefine(value = "出厂编号/产品编号")
    private String factoryNum;

    @FieldDisplayDefine(value = "制造日期")
    private String produceDate;

    @FieldDisplayDefine(value = "是否进口")
    private String imported;

    @FieldDisplayDefine(value = "制造国")
    private String produceCountry;

    @FieldDisplayDefine(value = "产品质量合格证", type = JSON.class)
    private String productQualityYieldProve;

    @FieldDisplayDefine(value = "安装及使用维护保养说明", type = JSON.class)
    private String insUseMaintainExplain;

    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessoriesFact;

    @FieldDisplayDefine(value = "制造标准", type = JSON.class)
    private String factoryStandard;

    @FieldDisplayDefine(value = "制造监督检验报告", type = JSON.class)
    private String factSupervisionInspectionReport;

    @FieldDisplayDefine(value = "锅炉能效证明文件", type = JSON.class)
    private String boilerEnergyEfficiencyCertificate;
}
