package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.yeejoin.amos.boot.module.tcm.biz.service.impl.HistoryDataDealServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/history-data")
@Api(tags = "历史数据处理控制器")
public class HistoryDataDealController {

    private HistoryDataDealServiceImpl historyDataDealService;

    public HistoryDataDealController(HistoryDataDealServiceImpl historyDataDealService) {
        this.historyDataDealService = historyDataDealService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/user-permission/update")
    @ApiOperation(httpMethod = "PUT", value = "人员需求2970新增资质后, 检验检测资质存量数据刷库")
    public ResponseModel<Integer> userPermissionUpdate() {
        return ResponseHelper.buildResponse(historyDataDealService.userPermissionUpdate());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/user-person-type/update")
    @ApiOperation(httpMethod = "PUT", value = "人员需求2970新增资质后, 人员类型去掉维保，归到作业人员")
    public ResponseModel<Integer> userPersonTypeUpdate() {
        return ResponseHelper.buildResponse(historyDataDealService.userPersonTypeUpdate());
    }

}
