package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterExcelNaturalDto", description = "天然水源")
public class WaterExcelNaturalDto extends WaterBaseResourceDto {

	@ExcelIgnore
	private static final long serialVersionUID = 1L;

	@ExcelProperty(value = "高度（cm）", index = 15)
	@ApiModelProperty(value = "高度（cm）")
	private Float height;

	@ExcelIgnore
	@ApiModelProperty(value = "水源类型代码")
	private String typeCode;

	@ExplicitConstraint(type = "TRSYLX", indexNum = 16, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "水源类型", index = 16)
	@ApiModelProperty(value = "水源类型")
	private String type;

	@ExcelProperty(value = "容积（m³）", index = 17)
	@ApiModelProperty(value = "容积（m³）")
	private Float volume;

	@ExcelProperty(value = "面积（㎡）", index = 18)
	@ApiModelProperty(value = "面积（㎡）")
	private Float area;

	@ExcelIgnore
	@ApiModelProperty(value = "水源可用状态类别代码")
	private String statusCode;

	@ExplicitConstraint(type = "SYZT", indexNum = 19, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "水源可用状态", index = 19)
	@ApiModelProperty(value = "水源可用状态类别名称")
	private String status;

	@ExcelIgnore
	@ApiModelProperty(value = "有无枯水期")
	private Boolean hasDrySeason;

	@ExplicitConstraint(indexNum = 20, source = { "有", "无" }) // 固定下拉内容
	@ExcelProperty(value = "有无枯水期", index = 20)
	@ApiModelProperty(value = "有无枯水期")
	private String hasDrySeasonType;

	@ExcelProperty(value = "水质情况", index = 21)
	@ApiModelProperty(value = "水质情况")
	private String qualitySituationInfo;

	@ExcelProperty(value = "四季变化简要情况", index = 22)
	@ApiModelProperty(value = "四季变化简要情况")
	private String seasonChangeInfo;

	@ExcelProperty(value = "枯水期跨度简要情况", index = 23)
	@ApiModelProperty(value = "枯水期跨度简要情况")
	private String dryPeriodSpan;


}
