package com.yeejoin.amos.patrol.business.dao.repository;

import com.yeejoin.amos.patrol.dao.entity.RoutePoint;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;

@Repository("iRoutePointDao")
public interface IRoutePointDao extends BaseDao<RoutePoint, Long> {

    @Query(value = "SELECT COUNT( point_id ) FROM p_route_point where route_id = ?1", nativeQuery = true)
    int countRoutePoint(Long routeId);

    @Query(value = "SELECT * FROM p_route_point where point_id = ?1", nativeQuery = true)
    List<RoutePoint> queryByPointId(Long pointId);

    @Query(value = "SELECT IfNULL(max(order_no),0) FROM p_route_point where route_id = ?1", nativeQuery = true)
    int maxRoutePointOrderNo(Long routeId);

    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point WHERE route_id = ?1", nativeQuery = true)
    void delRoutePointByRouteId(Long routeId);


    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point WHERE point_id = ?1", nativeQuery = true)
    void delRoutePointByPointId(Long pointId);

    @Query(value = "SELECT DISTINCT point_id FROM p_route_point where route_id = ?1", nativeQuery = true)
    List<Long> queryRoutePointIds(Long routeId);

    @Modifying
    @Transactional
    @Query(value = "select * from p_route_point WHERE route_id = ?1 and point_id in (?2)", nativeQuery = true)
    List<RoutePoint> queryRoutePoint(Long routeId, Long[] pointIds);


    @Modifying
    @Transactional
    @Query(value = "select * from p_route_point WHERE route_id = ?1 ", nativeQuery = true)
    List<RoutePoint> queryRoutePointList(Long routeId);


    @Modifying
    @Query(value = "select point_id from p_route_point WHERE route_id = ?1", nativeQuery = true)
    List<Long> findAllByRouteId(Long routeId);

    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point WHERE point_id in (?1)", nativeQuery = true)
    void delRoutePointByPointId(List<Long> pointIds);

    @Query(value = "SELECT id FROM p_route_point WHERE point_id IN (?1)", nativeQuery = true)
    List<BigInteger> queryRoutePointByPointId(List<Long> pointIds);

    @Query(value = "SELECT DISTINCT point_id FROM p_route_point where route_id = ?1", nativeQuery = true)
    List<String> getRoutePointIds(String routeId);

    int deleteByRouteIdAndPointIdInAndIdNotIn(Long targetRouteId, List<Long> targetPointIds, List<Long> ids);
}
