package com.yeejoin.amos.patrol.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.patrol.business.constants.XJConstant;
import com.yeejoin.amos.patrol.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.PointMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.RouteMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.RoutePointItemMapper;
import com.yeejoin.amos.patrol.business.dao.repository.*;
import com.yeejoin.amos.patrol.business.dto.PointClassifySynDto;
import com.yeejoin.amos.patrol.business.entity.mybatis.CheckPtListBo;
import com.yeejoin.amos.patrol.business.feign.EquipFeign;
import com.yeejoin.amos.patrol.business.feign.JcsFeignClient;
import com.yeejoin.amos.patrol.business.param.*;
import com.yeejoin.amos.patrol.business.service.intfc.IPatrolDataSyncService;
import com.yeejoin.amos.patrol.business.service.intfc.IPointService;
import com.yeejoin.amos.patrol.business.util.DaoCriteria;
import com.yeejoin.amos.patrol.business.vo.*;
import com.yeejoin.amos.patrol.common.enums.PointStatusEnum;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.response.PointResponse;
import com.yeejoin.amos.patrol.core.util.StringUtil;
import com.yeejoin.amos.patrol.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.patrol.dao.entity.*;
import com.yeejoin.amos.patrol.exception.YeeException;
import com.yeejoin.amos.patrol.feign.RemoteSecurityService;
import com.yeejoin.amos.safety.common.cache.PointStatusCache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.util.Sets;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.beans.PropertyDescriptor;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service("pointService")
@Slf4j
public class PointServiceImpl implements IPointService {

    @Autowired
    private IPointDao iPointDao;

    @Autowired
    PointMapper pointMapper;

    @Autowired
    private IPointClassifyDao iPointClassifyDao;

    @Autowired
    private IPointInputItemDao iPointInputItemDao;

    @Autowired
    private IPointPhotoDao iPointPhotoDao;

    @Autowired
    private IRoutePointDao iRoutePointDao;

    @Autowired
    private IPlanTaskDetailDao iPlanTaskDetailDao;

    @Autowired
    private IRoutePointItemDao iRoutePointItemDao;

    @Resource
    private RouteMapper routeMapper;

    @Autowired
    private ICatalogTreeDao catalogTreeDao;
    @Autowired
    private InputItemMapper inputItemMapper;
    @Autowired
    private RoutePointItemMapper routePointItemMapper;
    @Resource
    IPlanTaskDao planTaskDao;
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    @Autowired
    private IInputItemDao inputItemDao;
    @Autowired
    private  EquipFeign equipFeign;

    @Autowired
    private JcsFeignClient jcsFeignClient;

    @Autowired
    private IPatrolDataSyncService patrolDataSyncService;

    //管控形式 字典
    private static final String formOfManagementAndControl= "riskForm";

    @Override
    @Transactional
    public Point addPoint(PointParam pointParam) {
        // 保存点基本信息
        Point point = pointParam.getPoint();
        point.setIsDelete(false);
        iPointDao.saveAndFlush(point);
        addClassifyAndInputItem(pointParam, point);
        return point;
    }

    @Override
    @Transactional
    public Point newAddPoint(NewPointParam pointParam) {
        // 保存点基本信息
        Point point = pointParam.getPoint();
        point.setIsDelete(false);
        iPointDao.saveAndFlush(point);
        newAddClassifyAndInputItem(pointParam, point);
        return point;
    }

    @Override
    public void addPointClassifyByPointId(PointClassify pointClassify) {

        iPointClassifyDao.saveAndFlush(pointClassify);

    }

    @Override
    public void addPointClassifyByPointIdList(List<PointClassify> pointClassify) {
        iPointClassifyDao.saveAll(pointClassify);
    }

    @Override
    @Transactional
    public Point addPointNew(Point point) {
        // 保存点基本信息
        point.setIsDelete(false);
        iPointDao.saveAndFlush(point);
        return point;
    }


    @Override
    public void addMovePoint(MovePointParam param) {
        Point point = new Point();
        BeanUtils.copyProperties(param, point);
        point.setIsFixed("0");
        iPointDao.saveAndFlush(point);
        List<PointInputItem> pointInputItems = new ArrayList<>();
        if (!ObjectUtils.isEmpty(param.getInputItems())) {
            String[] ids = param.getInputItems().split(",");
            int index = 0;
            for (String id : ids) {
                PointInputItem item = new PointInputItem();
                item.setInputItemId(Integer.parseInt(id));
                item.setOrderNo(index++);
                item.setPointId(point.getId());
                item.setCreateDate(new Date());
                pointInputItems.add(item);
            }
            iPointInputItemDao.saveAll(pointInputItems);
        }
    }

    @Override
    @Transactional
    public List<Long> addImportPoint(List<PointImportParam> list, String orgCode, String userId) {
        List<Long> ids = new ArrayList<>();

        String structListString =  equipFeign.getStructureNameAll();
        JSONObject jsonObject =JSONObject.parseObject(structListString);
        JSONArray structList = jsonObject.getJSONArray("result");
        for (PointImportParam param : list) {
            Point point = new Point();
            // BeanUtils.copyProperties(param, point);
            int count = iPointDao.findByPointNo(param.getPointNo(), orgCode);
            if (count > 0) {// 该单位已存在该编号的点
                throw new BadRequest(param.getPointNo()+"该编号已存在");
            }
            if (ObjectUtils.isEmpty(param.getChargePersonId())) {
                throw new BadRequest("责任人不能为空");
            }
            if (!ObjectUtils.isEmpty(param.getName())) {
                List<Point> result = iPointDao.findByName(param.getName(), null);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
                    throw new BadRequest(param.getName()+"该名称巡检点已存在");
                }
            }
            if (!ObjectUtils.isEmpty(param.getPointNo())) {
                List<Point> result = iPointDao.findByNo(param.getPointNo(), null);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
                    throw new BadRequest(param.getPointNo()+"该编号已存在");
                }
            }
            point.setAddress(param.getAddress());
            point.setCatalogId(param.getCatalogId() == null ? 0 : param.getCatalogId());
            // 负责人
            if (!ObjectUtils.isEmpty(param.getChargePersonId())) {
                String[] principal = param.getChargePersonId().split("@");
                point.setChargePersonId(principal[1]);
                point.setChargePersonName(principal[0]);
            }

            // 归属部门
            if (!ObjectUtils.isEmpty(param.getChargeDeptId())) {
                String[] dept = param.getChargeDeptId().split("@");
                point.setChargeDeptId(dept[1]);
                point.setBizOrgName(dept[0]);
                ResponseModel<Object> companyInfo = jcsFeignClient.getCompanyInfo(dept[1]);
                if ("200".equals(String.valueOf(companyInfo.getStatus()))) {
                    Object obj = companyInfo.getResult();
                    if (!ObjectUtils.isEmpty(obj)) {
                        String bizOrgCode = ((Map<String, Object>) obj).get("bizOrgCode").toString();
                        point.setBizOrgCode(bizOrgCode);
                    }

                }


            }

            // 所在建筑
            if (!ObjectUtils.isEmpty(param.getAreaId())) {
                String[] area = param.getAreaId().split("@");
                point.setRiskSourceId(area[1]);
            }
            //point.setChargePersonId(param.getChargePersonId());
            // point.setDistance(param.getDistance() == null ? 0 :
            // param.getDistance());
            // point.setExtendJson(param.getExtendJson());
            //point.setFixedShot(param.getFixedShot() == null ? 0 : param.getFixedShot());
            point.setIsFixed(param.getIsFixed());
            point.setIsScore(param.getIsScore());
            // point.setLatitude(param.getLatitude());
            // point.setLongitude(param.getLongitude());
            point.setLevel(param.getLevel());
            point.setName(param.getName());
            point.setOffline(param.getOffline().equals("1") ? true : false);
            point.setPointNo(param.getPointNo());
            point.setRemark(param.getRemark());
            // point.setRouteId(param.getRouteId());
            // point.setRouteName(param.getRouteName());
            // point.setSaveGps(param.getSaveGps());
            point.setShotMaxNumber(param.getShotMaxNumber() == null ? 0 : Integer.parseInt(param.getShotMaxNumber()));
            point.setShotMinNumber(param.getShotMinNumber() == null ? 0 : Integer.parseInt(param.getShotMinNumber()));
            // point.setUsuallyShot(param.getUsuallyShot());
            //point.setCoordinates(param.getCoordinates());
            //point.setFloor(param.getFloor());
            point.setIsDelete(false);
            point.setOrgCode(orgCode);
            point.setCreateDate(new Date());
            point.setCreatorId(userId);
            point.setIsIndoor(param.getIsIndoor().equals("1") ? true : false);
//            CatalogTree catalog = catalogTreeDao.findOneByNameAndOrgCode(param.getCatalogName(),
//            		orgCode);
//
//            point.setCatalogId(catalog.getId());
            if(!org.springframework.util.StringUtils.isEmpty(param.getAddress())){
                for (int i = 0; i < structList.size(); i++) {
                    if(structList.getJSONObject(i).get("name").equals(param.getAddress())){
                        point.setRiskSourceId(structList.getJSONObject(i).get("id").toString());
                    }
                }
            }
            iPointDao.saveAndFlush(point);
            ids.add(point.getId());

            if (StringUtil.isNotEmpty(param.getEquipInputInfo())) {
                String[] info = param.getEquipInputInfo().split("\\|");
                Set<String> infos=new HashSet<>();
                Collections.addAll(infos,info);
                for (String e : infos) {
                        String[] split = e.split(":");
                        String equipCode = split[0];
                         Set<String> inputItemCodes = new HashSet<>(Arrays.asList(split[1].split(",")));
                   //     List<String> inputItemCodes = Arrays.asList(split[1].split(","));
                        List<RoutePoint> routePointList = iRoutePointDao.queryByPointId(point.getId());
                        HashMap<String, String> equipByCode = routePointItemMapper.getEquipByCode(equipCode);
                        if (ObjectUtils.isEmpty(equipByCode)) {
                            throw new BadRequest("装备编码不存在");
                        }
                        PointClassify newPointClassify = new PointClassify();
                        newPointClassify.setEquipmentId(equipByCode.get("equipmentId"));
                        newPointClassify.setName(equipByCode.get("name"));
//                        newPointClassify.setInspectionSpecName();
                        newPointClassify.setCreatorId(userId);
                        newPointClassify.setPointId(point.getId());
                        newPointClassify.setOrderNo(0);
                        newPointClassify.setDataSourceCode("1");
                        newPointClassify.setDataSourceName("消防装备");
                        newPointClassify.setAddress(equipByCode.get("address"));
                        newPointClassify.setBuildingId(String.valueOf(equipByCode.get("sourceId")));
                        String uuid = UUID.randomUUID().toString().replace("-", "");
                        newPointClassify.setOriginalId(uuid.substring(0, 16));
                        newPointClassify.setCategoryCode(equipByCode.get("categoryCode"));
                        newPointClassify.setCategoryName(equipByCode.get("categoryName"));
                        newPointClassify.setCode(equipByCode.get("code"));
                        newPointClassify.setBuildingName(equipByCode.get("fullName"));
                        List<PointClassify> pointClassifies = iPointClassifyDao.queryByPointIdAndEquipmentId(point.getId(), equipByCode.get("equipmentId"));
                        if (!CollectionUtils.isEmpty(pointClassifies)) {
                            newPointClassify.setId(pointClassifies.get(0).getId());
                        }
                        this.addPointClassifyByPointId(newPointClassify);
                        List<PointInputItemVo> customInputList = inputItemMapper.queryCustomInputItemByCodes(inputItemCodes);
                        if (ValidationUtil.isEmpty(customInputList) || customInputList.size() < inputItemCodes.size()) {
                            throw new BadRequest(split[1]+"中存在不正确的检查项编号");
                        }
                        for (PointInputItemVo pItemVo : customInputList) {
                            PointInputItem pointInputItem = new PointInputItem();
                            pointInputItem.setPointId(newPointClassify.getPointId());
                            pointInputItem.setInputItemId(pItemVo.getId());
                            pointInputItem.setClassifyIds(Long.valueOf(newPointClassify.getId()).toString());
                            pointInputItem.setId(0);
                            pointInputItem.setOrderNo(pItemVo.getpOrderNo());
                            PointInputItem pointInputItemResult = iPointInputItemDao.saveAndFlush(pointInputItem);
                            //更新巡检路线
                            if (routePointList.size() > 0) {
                                Long classifyId = newPointClassify.getId();
                                for (RoutePoint routePoint : routePointList) {
                                    RoutePointItem routePointItem = new RoutePointItem();
                                    routePointItem.setPointClassifyId(classifyId);
                                    routePointItem.setPointInputItemId(pointInputItemResult.getId());
                                    routePointItem.setRoutePointId(routePoint.getId());
                                    iRoutePointItemDao.save(routePointItem);
                                }
                            }
                        }
                }

            }

            String inputItems = param.getInputItems();
            if (!ObjectUtils.isEmpty(inputItems)) {
                String[] itemNos = inputItems.replaceAll(" ", "").split(",");

                List<InputItemVo> inputItemList = inputItemMapper.getInputItemListByitemNos(itemNos);
                int orderNo = 0;
                for (InputItemVo inputItem : inputItemList) {
                    PointInputItem pointInputItem = new PointInputItem();
                    pointInputItem.setPointId(point.getId());
                    pointInputItem.setInputItemId(inputItem.getId());
                    // pointInputItem.setClassifyIds(0);
                    pointInputItem.setId(0);
                    pointInputItem.setOrderNo(orderNo++);
                    iPointInputItemDao.save(pointInputItem);
                }
            }
        }
        return ids;
    }

    /**
     * 增加点的分类和项
     *
     * @param pointParam
     * @param point
     */
    private void addClassifyAndInputItem(PointParam pointParam, Point point) {
        long pointId = point.getId();

        // 保存点分类信息
        Map<Long, Long> classifyNameIdMap = new HashMap<>();
        for (PointClassify pointClassify : pointParam.getPointClassifyList()) {
            if (pointClassify != null) {// pointClassify.getId() == 0 表示新增
                PointClassify newPointClassify = new PointClassify();
                BeanUtils.copyProperties(pointClassify, newPointClassify);
                newPointClassify.setCreatorId(point.getCreatorId());
                newPointClassify.setPointId(pointId);
                newPointClassify.setId(0);
                iPointClassifyDao.saveAndFlush(newPointClassify);

                classifyNameIdMap.put(pointClassify.getId(), newPointClassify.getId());
            }
        }

        // 保存点的巡检项信息
        List<PointInputItemVo> pointInputItemVoList = pointParam.getInputItemVoInfo();
        List<Long> pointInputItemIdList = new ArrayList<>(); // 页面选择的点的所有项列表
        Map<Long, Integer> inputIdOrderNoMap = new HashMap<>();
        for (PointInputItemVo pItemVo : pointInputItemVoList) {
            pointInputItemIdList.add(pItemVo.getId());
            inputIdOrderNoMap.put(pItemVo.getId(), pItemVo.getpOrderNo());
        }
        // List<Long> classifiedInputItemIdList = new ArrayList<>(); //
        // 页面已选分类的项列表
        // List<Long> unClassifiedInputItemIdList = pointInputItemIdList; //
        // 页面未分类的项列表
        Map<Long, List<Long>> classifyInputItemMap = pointParam.getClassifyInputItemMap(); // 前台传入的分类和项键值对
        Map<Long, String> itemClassifyIdMap = new HashMap<>();
        for (Long itemId : pointInputItemIdList) {
            Iterator<Map.Entry<Long, List<Long>>> iterator = classifyInputItemMap.entrySet().iterator();
            List<String> ids = new ArrayList<>();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<Long>> entry = iterator.next();
                List<Long> cItemIds = entry.getValue();
                if (cItemIds.contains(itemId) && !ids.contains(itemId)) {
                    ids.add(classifyNameIdMap.get(entry.getKey()) == null ? "0"
                            : classifyNameIdMap.get(entry.getKey()).toString());
                }
            }
            itemClassifyIdMap.put(itemId, StringUtils.join(ids.toArray(), ","));
        }

        for (Long inputItemId : pointInputItemIdList) {
            String[] ids=itemClassifyIdMap.get(inputItemId).split(",");
            for (int i = 0; i <ids.length ; i++) {
            PointInputItem pointInputItem = new PointInputItem();
            pointInputItem.setPointId(pointId);
            pointInputItem.setInputItemId(inputItemId);
            pointInputItem.setId(0);
            pointInputItem.setOrderNo(inputIdOrderNoMap.get(inputItemId));
            pointInputItem.setClassifyIds(ids[i]);
            iPointInputItemDao.save(pointInputItem);
            }

        }

        // 保存点的图片说明信息
        // TODO 图片上传接口调用
        List<PointPhoto> pointPhotoList = pointParam.getPointPhotoList();
        List<PointPhoto> newPointPhotoList = new ArrayList<>();
        for (PointPhoto pointPhoto : pointPhotoList) {
            PointPhoto newPointPhoto = new PointPhoto();
            BeanUtils.copyProperties(pointPhoto, newPointPhoto);
            newPointPhoto.setPointId(pointId);
            newPointPhoto.setOrgCode(pointParam.getLoginOrgCode());
            newPointPhoto.setId(0);
            newPointPhotoList.add(newPointPhoto);
        }
        iPointPhotoDao.saveAll(newPointPhotoList);
    }

    /**
     * 增加点的分类和项--新
     *
     * @param pointParam
     * @param point
     */
    private void newAddClassifyAndInputItem(NewPointParam pointParam, Point point) {
        long pointId = point.getId();
        //查询巡检路线和项的关系表
        List<RoutePoint> routePointList =  iRoutePointDao.queryByPointId(point.getId());
        int orderNo = 0;
        // 保存点分类信息
        Map<String, Long> classifyNameIdMap = new HashMap<>();
        for (PointInputItemNewVo pointClassify : pointParam.getInputItemVoInfo()) {
            if (pointClassify != null) {// pointClassify.getId() == 0 表示新增
                PointClassify pointResult= null;
                Optional<PointClassify>  optionalPointClassify = iPointClassifyDao.findById(pointClassify.getId());
                PointClassify newPointClassify = new PointClassify();
                newPointClassify.setPointId(pointId);
                newPointClassify.setEquipmentId(pointClassify.getEquipmentId());
                newPointClassify.setName(pointClassify.getName());
                newPointClassify.setInspectionSpecName(pointClassify.getInspectionName());
                newPointClassify.setCreatorId(point.getCreatorId());
                newPointClassify.setPointId(pointId);
                newPointClassify.setOrderNo(pointClassify.getOrderNo());
                newPointClassify.setDataSourceCode(pointClassify.getDataSourceCode());
                newPointClassify.setDataSourceName(pointClassify.getDataSourceName());
                newPointClassify.setAddress(pointClassify.getAddress());
                newPointClassify.setBuildingId(pointClassify.getBuildingId());
                newPointClassify.setOriginalId(pointClassify.getOriginalId());
                newPointClassify.setCategoryCode(pointClassify.getCategoryCode());
                newPointClassify.setCategoryName(pointClassify.getCategoryName());
                newPointClassify.setCode(pointClassify.getCode());
                newPointClassify.setBuildingName(pointClassify.getBuildingName());
                if(!optionalPointClassify.isPresent()) {
                    pointResult = iPointClassifyDao.saveAndFlush(newPointClassify);
                }else{
                    newPointClassify.setId(optionalPointClassify.get().getId());
                    pointResult = iPointClassifyDao.saveAndFlush(newPointClassify);
                }

            // 保存点的巡检项信息
            List<InputItem> pointInputItemVoList = inputItemDao.findByEquipmentName(pointClassify.getName());//规则巡检项
            List<PointInputItemVo> customInputList = pointClassify.getEquipIputDetailData();//自定义巡检项
            if(pointInputItemVoList.size()>0 && customInputList.size()==0){
                for (int i = 0; i <pointInputItemVoList.size() ; i++) {
                    PointInputItemVo pointInputItemVo = new PointInputItemVo();
                    BeanUtils.copyProperties(pointInputItemVoList.get(i),pointInputItemVo);
                    pointInputItemVo.setpOrderNo(i);
                    customInputList.add(pointInputItemVo);
                }
            }
            for (PointInputItemVo pItemVo : customInputList) {
                PointInputItem pointInputItem = new PointInputItem();
                if(pItemVo.getPointItemId()==0l){
                    pointInputItem.setPointId(pointId);
                    pointInputItem.setInputItemId(pItemVo.getId());
                    if(pointResult!=null){
                        pointInputItem.setClassifyIds(Long.valueOf(pointResult.getId()).toString());
                    }else{
                        pointInputItem.setClassifyIds(Long.valueOf(pointClassify.getId()).toString());
                    }
                    pointInputItem.setId(0);
                    pointInputItem.setOrderNo(pItemVo.getpOrderNo());
                    PointInputItem pointInputItemResult =  iPointInputItemDao.save(pointInputItem);
                    //更新巡检路线
                    if(routePointList.size()>0){
                        Long classifyId = 0l;
                        if(pointResult!=null){
                            classifyId=pointResult.getId();
                        }else{
                            classifyId=pointClassify.getId();
                        }

                        for (RoutePoint routePoint :routePointList) {
                            RoutePointItem routePointItem  = new RoutePointItem();
                            routePointItem.setPointClassifyId(classifyId);
                            routePointItem.setPointInputItemId(pointInputItemResult.getId());
                            routePointItem.setRoutePointId(routePoint.getId());
                            iRoutePointItemDao.save(routePointItem);
                        }
                    }
                }else {
                    pointInputItem.setId(pItemVo.getPointItemId());
                    pointInputItem.setInputItemId(pItemVo.getId());
                    pointInputItem.setPointId(pointId);
                    if(pointResult!=null){
                        pointInputItem.setClassifyIds(Long.valueOf(pointResult.getId()).toString());
                    }else{
                        pointInputItem.setClassifyIds(Long.valueOf(pointClassify.getId()).toString());
                    }
                    pointInputItem.setId(pItemVo.getPointItemId());
                    pointInputItem.setOrderNo(pItemVo.getpOrderNo());
                    iPointInputItemDao.save(pointInputItem);
                }
            }
            }
        }
        // 保存点的图片说明信息
        // TODO 图片上传接口调用
        List<PointPhoto> pointPhotoList = pointParam.getPointPhotoList();
        List<PointPhoto> newPointPhotoList = new ArrayList<>();
        for (PointPhoto pointPhoto : pointPhotoList) {
            PointPhoto newPointPhoto = new PointPhoto();
            BeanUtils.copyProperties(pointPhoto, newPointPhoto);
            newPointPhoto.setPointId(pointId);
            newPointPhoto.setOrgCode(pointParam.getLoginOrgCode());
            newPointPhoto.setId(0);
            newPointPhotoList.add(newPointPhoto);
        }

        iPointPhotoDao.saveAll(newPointPhotoList);
    }
    /**
     * 更新点的分类和项
     *
     * @param pointParam
     * @param point
     */
    private void updateClassifyAndInputItem(PointParam pointParam, Point point) {
        long pointId = point.getId();

        // 保存点分类信息
        Map<String, Long> classifyNameIdMap = new HashMap<>();
        for (PointClassify pointClassify : pointParam.getPointClassifyList()) {
            if (pointClassify != null) {// pointClassify.getId() == 0 表示新增
                PointClassify newPointClassify = new PointClassify();
                BeanUtils.copyProperties(pointClassify, newPointClassify);
                newPointClassify.setCreatorId(point.getCreatorId());
                newPointClassify.setPointId(pointId);
                if (ObjectUtils.isEmpty(newPointClassify.getCreateDate())) {
                	newPointClassify.setCreateDate(new Date());
                }
                iPointClassifyDao.saveAndFlush(newPointClassify);

                classifyNameIdMap.put(newPointClassify.getName(), newPointClassify.getId());
            }
        }

        // 保存点的巡检项信息
        List<PointInputItemVo> pointInputItemVoList = pointParam.getInputItemVoInfo();
        Map<Long, Integer> inputIdOrderNoMap = new HashMap<>();
        Map<Long, PointInputItemVo> allInputItem = new HashMap<>();
        List<Long> pointInputItemIdList = new ArrayList<>(); // 页面选择的点的所有项列表
        for (PointInputItemVo pItemVo : pointInputItemVoList) {
            allInputItem.put(pItemVo.getId(), pItemVo);
            pointInputItemIdList.add(pItemVo.getId());
            inputIdOrderNoMap.put(pItemVo.getId(), pItemVo.getpOrderNo());
        }

        Map<String, List<HashMap<Long, Long>>> classifyItemHashMap = pointParam.getClassifyInputItemEditMap(); // 前台传入的分类和项键值对
        Map<String, List<Long>> classifyInputItemMap = new HashMap<>();
        for (String key : classifyItemHashMap.keySet()) {
            List<Long> itemList = null;
            Set<Long> itemSet = new HashSet<>();
            List<HashMap<Long, Long>> itemIdList = classifyItemHashMap.get(key);
            for (HashMap<Long, Long> item : itemIdList) {
                for (Long itemId : item.keySet()) {
                    itemSet.add(itemId);
                }
            }
            itemList = new ArrayList(itemSet);
            classifyInputItemMap.put(key, itemList);
        }

        Map<Long, String> itemClassifyIdMap = new HashMap<>();
        for (Long itemId : pointInputItemIdList) {
            Iterator<Map.Entry<String, List<Long>>> iterator = classifyInputItemMap.entrySet().iterator();
            List<String> ids = new ArrayList<>();
            while (iterator.hasNext()) {
                Map.Entry<String, List<Long>> entry = iterator.next();
                List<Long> cItemIds = entry.getValue();
                if (cItemIds.contains(itemId) && !ids.contains(itemId)) {
                    ids.add(classifyNameIdMap.get(entry.getKey()).toString());
                }
            }
            itemClassifyIdMap.put(itemId, StringUtils.join(ids.toArray(), ","));
        }

        List<PointInputItem> pointInputItems = new ArrayList<>();
        for (Long inputItemId : pointInputItemIdList) {
            PointInputItem pointInputItem = iPointInputItemDao.getPointInputItem(pointId, inputItemId);
            if (pointInputItem == null) {
                pointInputItem = new PointInputItem();
            }
            pointInputItem.setPointId(pointId);
            pointInputItem.setInputItemId(inputItemId);
            pointInputItem.setClassifyIds(itemClassifyIdMap.get(inputItemId));
            pointInputItem.setOrderNo(inputIdOrderNoMap.get(inputItemId));
            pointInputItem = iPointInputItemDao.saveAndFlush(pointInputItem);
            pointInputItems.add(pointInputItem);
        }

        updateRoutePointItem(pointInputItems);
        // 保存点的图片说明信息
        // TODO 图片上传接口调用
        List<PointPhoto> pointPhotoList = pointParam.getPointPhotoList();
        List<PointPhoto> newPointPhotoList = new ArrayList<>();
        for (PointPhoto pointPhoto : pointPhotoList) {
            PointPhoto newPointPhoto = new PointPhoto();
            BeanUtils.copyProperties(pointPhoto, newPointPhoto);
            newPointPhoto.setPointId(pointId);
            newPointPhoto.setOrgCode(pointParam.getLoginOrgCode());
            newPointPhoto.setId(0);
            newPointPhotoList.add(newPointPhoto);
        }
        iPointPhotoDao.saveAll(newPointPhotoList);
    }

    void updateRoutePointItem(List<PointInputItem> pointInputItems) {


        List<RoutePointItem> updateData = new ArrayList<>();
        List<RoutePointItem> deleteData = new ArrayList<>();
        for (PointInputItem pointInputItem : pointInputItems) {
            List<RoutePointItem> routePointItems = iRoutePointItemDao.findAllByPointInputItemId(pointInputItem.getId());
            if (routePointItems.isEmpty()) {
                continue;
            }
            Map<Long,List<RoutePointItem>> routePointItemG = routePointItems.stream().collect(Collectors.groupingBy(RoutePointItem::getRoutePointId));
            List<String> classifyids = StringUtil.isNotEmpty(pointInputItem.getClassifyIds()) ? Arrays.asList(pointInputItem.getClassifyIds().split(",")) : new ArrayList<>();
            if (classifyids.isEmpty()) {
                //路线巡检项保留一个并且分类id为null
            	for(List<RoutePointItem> value : routePointItemG.values()){
            		List<Long> pointInputIds = new ArrayList<>();
            		for (int i = 0; i < value.size(); i++) {
                        RoutePointItem rp = value.get(i);
                        if(pointInputIds.contains(rp.getPointInputItemId())){
                        	  deleteData.add(rp);
                        }else{
                        	 rp.setPointClassifyId(null);
                             updateData.add(rp);
                        }
                        pointInputIds.add(rp.getPointInputItemId());
                    }
            	}

            } else {
            	for(List<RoutePointItem> value : routePointItemG.values()){
            		 RoutePointItem rp = value.get(0);
                     classifyids.forEach(classifyid -> {
                         RoutePointItem newRpi = new RoutePointItem();
                         newRpi.setRoutePointId(rp.getRoutePointId());
                         newRpi.setOrderNo(rp.getOrderNo());
                         newRpi.setPointInputItemId(rp.getPointInputItemId());
                         newRpi.setPointClassifyId(Long.valueOf(classifyid));
                         newRpi.setCreateDate(new Date());
                         updateData.add(newRpi);
                     });
                     deleteData.addAll(value);
            	}
            }
        }
        if (!deleteData.isEmpty()) {
            iRoutePointItemDao.deleteAll(deleteData);
        }
        if (!updateData.isEmpty()) {
            iRoutePointItemDao.saveAll(updateData);
        }
    }

    @Override
    @Transactional
    public List<Long> delPointById(Long[] ids) {
        List<Long> idList = new ArrayList<Long>();
        for (long pointId : ids) {
            idList.add(pointId);
        }
        iPointClassifyDao.deleteByPointId(idList); // 物理删除点的分类
        List<PointInputItem> pointInputItem = iPointInputItemDao.findAllById(idList);
        List<Long> pointInputItemIds = Lists.transform(pointInputItem, PointInputItem::getId);
        if(pointInputItemIds.size()>0)
        iPointInputItemDao.deleteFmeaRelationByPointInputItemIds(pointInputItemIds);//物理删除fmea关联巡检点项
        iPointInputItemDao.deleteByPointId(idList); // 物理删除p_point_inputitem表对应行
        iPointPhotoDao.deleteByPointId(idList); // 物理删除点的图片信息
        // iRoutePointDao.delRoutePointByPointId(idList); //
        // 物理删除p_route_point中相关行
        List<BigInteger> routePointIdList = iRoutePointDao.queryRoutePointByPointId(idList);
        for (BigInteger routePointId : routePointIdList) {
            iRoutePointItemDao.delRoutePointItem(routePointId.longValue());
            iRoutePointDao.deleteById(Long.parseLong(routePointId.toString()));
        }
        List<PlanTask> planTaskList = new ArrayList<>();
        for (long pointId : idList) {
            List<PlanTaskDetail> planDetailList = iPlanTaskDetailDao.findALLByPointId(pointId);
            for (PlanTaskDetail planTaskDetail : planDetailList) {
                PlanTask planTask = planTaskDao.findById(planTaskDetail.getTaskNo()).get();
                planTaskList.add(planTask);
                if (planTask.getFinishStatus() > 1) {
                    continue;
                }
                if (1 == planTaskDetail.getIsFinish()) {
                    planTask.setFinishNum(planTask.getFinishNum() - 1);
                    planTask.setPointNum(planTask.getPointNum() - 1);
                    planTaskDao.save(planTask);
                } else {
                    planTask.setPointNum(planTask.getPointNum() - 1);
                    planTaskDao.save(planTask);
                }

            }
        }

        iPlanTaskDetailDao.deletePlanTaskDetailByPointId(idList); // 删除p_plan_task_detail相关行
        iPointDao.delPointById(idList);
        //  巡检站端与中心级数据同步
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                // 事物提交后业务逻辑
                patrolDataSyncService.planTaskDataSync(planTaskList);
            }
        });
        return idList;
    }

    @Override
    @Transactional
    public Point updatePoint(PointParam pointParam) {
        long pointId = pointParam.getPoint().getId();
        Point newPoint = iPointDao.findById(pointId).get();
        BeanUtils.copyProperties(pointParam.getPoint(), newPoint);
        newPoint.setLastUpdateTime(new Date());
        iPointDao.save(newPoint);

        List<PointInputItemVo> oldInputItemList = queryOldPointInputItem(pointId); // 新的巡检项的补集，即需要删除的项
        List<PointInputItemVo> newInputItemList = pointParam.getInputItemVoInfo();
        List<Long> ids = new ArrayList<>();
        newInputItemList.forEach(item -> {
            PointInputItem pii = iPointInputItemDao.getPointInputItem(pointId, item.getId());
            if (pii != null) {
                ids.add(item.getPointItemId());
            }
        });
        List<Long> pItemIds = new ArrayList<>();
        oldInputItemList.forEach(item -> {
            if (!ids.contains(item.getPointItemId())) {
                pItemIds.add(item.getPointItemId());
            }
        });
        if (pItemIds.size() > 0) {
            iPointInputItemDao.delPointInputItemById(pItemIds);
            iRoutePointItemDao.delRoutePointItemByItemId(pItemIds);// 删除p_route_point_item中使用到该项的行
        }

        // 删除点的旧分类
        // 删除点分类时更新p_point_inputitem里面分类id
        List<PointClassify> newPointClassifyList = pointParam.getPointClassifyList();
        List<PointClassify> oldPointClassifyList = queryPointClassify(pointId);// 新的点分类的补集，即需要删除的分类
        newPointClassifyList.forEach(item -> {
            Iterator<PointClassify> iter2 = oldPointClassifyList.iterator();
            while (iter2.hasNext()) {
                PointClassify pClassify = iter2.next();
                if (item.getId() == pClassify.getId()) {
                    iter2.remove();
                }
            }
        });
        for (PointClassify classify : oldPointClassifyList) {
            iPointClassifyDao.deleteById(classify.getId());
        }

        // 删除点的旧图片信息
        List<PointPhoto> oldPointPhotoList = queryPointPhoto(pointId);
        iPointPhotoDao.deleteAll(oldPointPhotoList);

        updateClassifyAndInputItem(pointParam, newPoint);
        return newPoint;

    }

    @Override
    @Transactional
    public Point updatePointNew(NewPointParam newpointParam) {
        long pointId = newpointParam.getPoint().getId();
        Point newPoint = iPointDao.findById(pointId).get();
        BeanUtils.copyProperties(newpointParam.getPoint(), newPoint);
        newPoint.setLastUpdateTime(new Date());
        iPointDao.save(newPoint);

        List<PointClassify> oldPointClassifyList = queryPointClassify(pointId);// 新的点分类的补集，即需要删除的分类
        List<PointInputItemNewVo> newPointClassifyList = newpointParam.getInputItemVoInfo();// 新的点分类的补集，即需要删除的分类
//        List<Long> oldClassIdList=oldPointClassifyList.stream().map(PointClassify::getId).distinct().collect(Collectors.toList());
        List<Long> newClassIdList=newPointClassifyList.stream().map(PointInputItemNewVo::getId).distinct().collect(Collectors.toList());
        //如果传入新的分类，旧列表里不存在，就删除
        for (PointClassify classify : oldPointClassifyList) {
            if(!newClassIdList.contains(classify.getId())){
                iPointClassifyDao.deleteById(classify.getId());
//                PointInputItem pointInputItem =   iPointInputItemDao.deleteClassifyId(classify.getId());
//                iRoutePointItemDao.delPointInputItemId(pointInputItem.getId());
            }
        }

        List<PointInputItemVo> oldInputItemList = queryOldPointInputItem(pointId); // 新的巡检项的补集，即需要删除的项
        List<PointInputItemVo> newInputItemList = new ArrayList<>();
        List<PointInputItemNewVo>  classList = newpointParam.getInputItemVoInfo();
        for (int i = 0; i <classList.size() ; i++) {
            newInputItemList.addAll(classList.get(i).getEquipIputDetailData());
        }
        List<Long> ids = new ArrayList<>();
        newInputItemList.forEach(item -> {
//            PointInputItem pii = iPointInputItemDao.getPointInputItem(pointId, item.getPointItemId());
//            if (pii != null) {
                ids.add(item.getPointItemId());
//            }
        });
        List<Long> pItemIds = new ArrayList<>();
        oldInputItemList.forEach(item -> {
            if (!ids.contains(item.getPointItemId())) {
                pItemIds.add(item.getPointItemId());
            }
        });
        if (pItemIds.size() > 0) {
            iPointInputItemDao.delPointInputItemById(pItemIds);
            iRoutePointItemDao.delRoutePointItemByItemId(pItemIds);// 删除p_route_point_item中使用到该项的行
        }


//         删除点的旧图片信息
        List<PointPhoto> oldPointPhotoList = queryPointPhoto(pointId);
        iPointPhotoDao.deleteAll(oldPointPhotoList);
        newAddClassifyAndInputItem(newpointParam, newPoint);
        return newPoint;

    }

    @Override
    @Transactional
    public void saveAs(Long[] pointIds) {
        // 保存点所有巡检项、点图片信息、点的扩展分类信息
        for (Long pointId : pointIds) {
            Point point = iPointDao.findById(pointId).get();
            String orgCode = point.getOrgCode();
            List<PointPhoto> pointPhotoList = queryPointPhoto(pointId);
            List<PointClassify> pointClassifyList = queryPointClassify(pointId);
            List<PointInputItemVo> inputItemList = queryPointInputItem(pointId);
            Map<Long, List<Long>> classifyInputItemMap = queryPointClassifyNameMap(pointId);

            Point newPoint = new Point();
            BeanUtils.copyProperties(point, newPoint);
            newPoint.setName(point.getName() + "复制");
            newPoint.setPointNo(point.getPointNo() + "_copy");
            newPoint.setId(0);
            newPoint.setStatus(PointStatusEnum.UNPLAN.getCode());
            PointParam pointParam = new PointParam();
            pointParam.setPoint(newPoint);
            pointParam.setClassifyInputItemMap(classifyInputItemMap);
            pointParam.setInputItemVoInfo(inputItemList);
            pointParam.setLoginOrgCode(orgCode);
            pointParam.setPointClassifyList(pointClassifyList);
            pointParam.setPointPhotoList(pointPhotoList);

            addPoint(pointParam);
        }
    }

    @Override
    public void importPoint() {
        // TODO Auto-generated method stub

    }

    @Override
    public void exportPoint() {
        // TODO Auto-generated method stub

    }

    @Override
    public Point queryPointById(Long id) {
        return iPointDao.findById(id).get();
    }

    @Override
    public List queryItemList4RoutePointNew(Long routeId,Long pointId, Long classifyId) {
        if (pointId == null || classifyId == null) {
            throw new RuntimeException("查询条件有误");
        }
        List<Map<String, Object>> resList = pointMapper.queryItemList4RoutePoint(pointId, classifyId);
        //查询管控字典值，并替换到返回值
        HashMap<String, String> dictMap = new HashMap<>();
        List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(formOfManagementAndControl).getResult();
        result.forEach(x-> dictMap.put(x.getDictDataKey(),x.getDictDataValue()));
        resList.stream().peek(item->{
            if (item.containsKey("input_classify")){
                item.put("input_classify",dictMap.getOrDefault(item.get("input_classify").toString(),"其他"));
            }
        }).collect(Collectors.toList());
        //给前端返回是否绑定标识
        Long[] longs = new Long[]{pointId};
        List<RoutePoint> list = iRoutePointDao.queryRoutePoint(routeId, longs);
        String excludeItems = list.get(0).getExcludeItems();
        if(excludeItems!=null){
            resList.forEach(e -> {
                if (e.containsKey("input_classify")) {
                    if ("WGJC".equals(e.get("input_classify").toString())) {
                        e.put("input_classify", "外观检查");
                    } else if ("GNCS".equals(e.get("input_classify").toString())) {
                        e.put("input_classify", "功能测试");
                    } else if ("HJJC".equals(e.get("input_classify").toString())) {
                        e.put("input_classify", "环境检查");
                    }
                }
                if (excludeItems.contains(e.get("itemId").toString())){
                    e.put("checked",true);
                }else {
                    e.put("checked",false);
                }
            });
        }

        return resList;
    }


    @Override
    public Page<List<Point>> queryPointInfoPage(List<DaoCriteria> criterias) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Page<PointVo> queryPointInfo(List<DaoCriteria> criterias, CommonPageable commonPageable, String loginOrgCode) {
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
//        Sort sort = new Sort(Sort.Direction.DESC, "id");
        Sort sort = Sort.by("id").descending();
        commonPageable.setSort(sort);
        Page<Point> pointPage = iPointDao.findAll(spec, commonPageable);
        List<PointVo> pointVoList = new ArrayList<>();
        List<CatalogTree> catalogTrees = catalogTreeDao.findByOrgCode(loginOrgCode);
        Map<Long,String> catalogTreesName = catalogTrees.stream().collect(Collectors.toMap(CatalogTree::getId,CatalogTree::getName));
        for (Point point : pointPage) {
            PointVo pointVo = new PointVo();
            BeanUtils.copyProperties(point, pointVo);
            pointVo.setShotNumber(point.getShotMinNumber() + "-" + point.getShotMaxNumber());
            if(catalogTreesName.containsKey(point.getCatalogId())){
                pointVo.setCatalogName(catalogTreesName.get(point.getCatalogId()));
            }
            List<String> classifyNameList = new ArrayList<>();
            List<PointClassify> pointClassifys = iPointClassifyDao.getPointClassifyByPointId(point.getId());
            for (PointClassify pointClassify : pointClassifys) {
                classifyNameList.add(pointClassify.getName());
            }
            String classifynames = StringUtils.join(classifyNameList.toArray(), ",");
            pointVo.setClassifyName(classifynames);
            pointVoList.add(pointVo);
        }
        Pageable pageable = new CommonPageable(pointPage.getNumber(), pointPage.getSize(), pointPage.getSort());

        Page<PointVo> pointVoPage = new PageImpl<>(pointVoList, pageable, pointPage.getTotalElements());
        return pointVoPage;
    }

    @Override
    public List<PointVo> queryAllPoint() {
        List<PointVo> returnList = new ArrayList<>();
        List<Point> list = iPointDao.findAll();

        if (!CollectionUtils.isEmpty(list)) {
            for (Point point : list) {
                PointVo pointVo = new PointVo();
                BeanUtils.copyProperties(point, pointVo);
                returnList.add(pointVo);
            }
        }

        return returnList;
    }

    @Override
    public List<PointInputItemVo> queryPointInputItem(Long pointId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById1(pointId, null);
        Map<Long, PointInputItemVo> itemMap = new HashMap<>();
        for (PointInputItemVo itemVo : inputItemList) {
            itemMap.put(itemVo.getId(), itemVo);
        }
        List<PointInputItemVo> list = new ArrayList<>();
        itemMap.values().forEach(item -> {
            list.add(item);
        });
        return list;
    }

    // 暂未用到
    @Override
    public Map<String, List<PointInputItemVo>> queryPointClassifyWithInputItem(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<String, List<PointInputItemVo>> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            classifyInputItemMap.put(pointClassify.getName() + "*" + pointClassify.getOrderNo(), inputItemList);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        List<PointInputItemVo> unClassifiedPointInputItemList = queryPointInputItem(pointId); // 未分类的巡检项列表
        unClassifiedPointInputItemList.removeAll(classifiedInputItemList);
        if (!unClassifiedPointInputItemList.isEmpty()) {
            classifyInputItemMap.put("未分类", unClassifiedPointInputItemList);
        }
        return classifyInputItemMap;
    }

    private Map<Long, List<PointInputItemVo>> queryPointClassify3(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<Long, List<PointInputItemVo>> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            classifyInputItemMap.put(pointClassify.getId(), inputItemList);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        List<PointInputItemVo> unClassifiedPointInputItemList = queryPointInputItem(pointId); // 未分类的巡检项列表
        unClassifiedPointInputItemList.removeAll(classifiedInputItemList);
        if (!unClassifiedPointInputItemList.isEmpty()) {
            // PointClassify pointClassify = new PointClassify();
            // pointClassify.setName("未分类");
            classifyInputItemMap.put(null, unClassifiedPointInputItemList);
        }
        return classifyInputItemMap;
    }

    @Override
    public List<PointPhoto> queryPointPhoto(Long pointId) {
        List<PointPhoto> pointPhotoList = pointMapper.getPointPhotoByPointId(pointId);
        return pointPhotoList;
    }

    @Override
    public void addPointPhoto(Long pointId) {
        // TODO Auto-generated method stub

    }

    private Map<Long, List<Long>> queryPointClassifyNameMap(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<Long, List<Long>> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            List<Long> inputItemIdList = new ArrayList<>();
            for (PointInputItemVo inputItem : inputItemList) {
                inputItemIdList.add(inputItem.getId());
            }
            classifyInputItemMap.put(pointClassify.getId(), inputItemIdList);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        List<PointInputItemVo> unClassifiedPointInputItemList = queryPointInputItem(pointId); // 未分类的巡检项列表
        unClassifiedPointInputItemList.removeAll(classifiedInputItemList);
        if (!unClassifiedPointInputItemList.isEmpty()) {
            List<Long> inputItemIdList = new ArrayList<>();
            for (PointInputItemVo inputItem : unClassifiedPointInputItemList) {
                inputItemIdList.add(inputItem.getId());
            }
            classifyInputItemMap.put(null, inputItemIdList);
        }
        return classifyInputItemMap;
    }

    @Override
    public List<PointClassify> queryPointClassify(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        return pointClassifyList;
    }

    @Override
    public List<PointInputItemVo> queryPointInputItemByClassify(Long pointId, Long classifyId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, classifyId);
        return inputItemList;
    }

    @Override
    public List<Point> queryPointList(List<String> ids, List<String> names, String orgCode) {
        return iPointDao.findAll(getPointSpecification(ids, names, orgCode));
    }

    private Specification getPointSpecification(List<String> ids, List<String> names, String orgCode) {
        return new Specification<Point>() { // 构建查询条件
            @Override
            public Predicate toPredicate(Root<Point> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> predicate = new ArrayList<>();
                if (!ObjectUtils.isEmpty(orgCode)) {
                    predicate.add(cb.equal(root.get("orgCode").as(String.class), orgCode ));
                }
                if (!ObjectUtils.isEmpty(names)) {
                    List<Predicate> namePredicate = new ArrayList<>();
                    for (String name : names) {
                        namePredicate.add(cb.like(root.get("name").as(String.class), "%" + name + "%"));
                    }
                    Predicate[] pre = new Predicate[namePredicate.size()];
                    predicate.add(cb.or(namePredicate.toArray(pre)));
                }
                if (!ObjectUtils.isEmpty(ids)) {
                    List<Predicate> noPredicate = new ArrayList<>();
                    for (String id : ids) {
                        noPredicate.add(cb.like(root.get("pointNo").as(String.class), "%" + id + "%"));
                    }
                    Predicate[] pre = new Predicate[noPredicate.size()];
                    predicate.add(cb.or(noPredicate.toArray(pre)));
                }

                Predicate[] pre = new Predicate[predicate.size()];
                return query.where(predicate.toArray(pre)).getRestriction();
            }
        };
    }

    @Override
    public Point queryPointByPointNo(HashMap<String, Object> params) {
        return iPointDao.findOne((Specification<Point>) (root, query, cb) -> {
            List<Predicate> predicate = new ArrayList<>();
            if (!ObjectUtils.isEmpty(params.get("pointNo"))) {
                predicate.add(cb.equal(root.get("pointNo").as(String.class), params.get("pointNo")));
            }
            if (!ObjectUtils.isEmpty(params.get("bizOrgCode"))) {
                predicate.add(cb.like(root.get("bizOrgCode").as(String.class), params.get("bizOrgCode").toString()+"%"));
            }
            Predicate[] pre = new Predicate[predicate.size()];
            return query.where(predicate.toArray(pre)).getRestriction();
        }).orElse(null);
    }

    @Override
    public Point setPatrolMode(Long pointId, Boolean isOffine) {
        if (iPointDao.existsById(pointId)) {
            Point point = iPointDao.findById(pointId).get();
            point.setOffline(isOffine);
            return iPointDao.save(point);
        }
        return null;
    }

    @Override
    public Page<PointVo> queryPointByPage(HashMap<String, Object> param, CommonPageable commonPageable) {
        int count = pointMapper.getPointCountByCondition(param);
        param.put("offset", commonPageable.getPageNumber() * commonPageable.getPageSize());
        param.put("pageSize", commonPageable.getPageSize());
        List<PointVo> list = pointMapper.getPointByCondition(param);
        Page<PointVo> pointVoPage = new PageImpl<>(list, commonPageable, count);
        return pointVoPage;
    }

    @Override
    public Map queryPointDetailById(Long id) {
        Map<String, Object> resp = new HashMap<String, Object>();
        Map<String, Object> point = pointMapper.getPointById(id);

        List<Map<String, Object>> inputItem = pointMapper.getPointInputItem(id);
        List<Map<String, Object>> routes = pointMapper.getPointRoute(id);
        List<Map<String, Object>> classify = pointMapper.getPointClassify(id);

        resp.put("point", point);
        resp.put("inputItems", inputItem);
        resp.put("routes", routes);
        resp.put("classify", classify);
        return resp;
    }

    @Override
    public Map queryPointDetailById1(String toke, String product, String appKey,Long id) {
        Map<String, Object> resp = new HashMap<String, Object>();
        Map<String, Object> point = pointMapper.getPointById(id);

//        if (StringUtil.isNotEmpty(point.get("depid"))) {
//            List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, point.get("depid") + "");
//            if (departmentBos != null && departmentBos.size() > 0) {
//                for (int i = 0; i < departmentBos.size(); i++) {
//                    point.put("departmentName", departmentBos.get(i).get("departmentName"));
//
//
//                }
//            }
//
//        }

        // deptName = checkPointBo.getExecuteDeptId();
//        if (StringUtil.isNotEmpty(point.get("userName"))) {
//            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, point.get("userName") + "");
//            String userName = "";
//            if (userModels != null && userModels.size() > 0) {
//                for (int i = 0; i < userModels.size(); i++) {
//                    if (i == userModels.size() - 1) {
//                        userName = userName + userModels.get(i).getRealName();
//                    } else {
//                        userName = userName + userModels.get(i).getRealName() + ",";
//                    }
//
//                }
//                point.put("userName", userName);
//            }
//
//
//        }







        List<Map<String, Object>> routes = pointMapper.getPointRoute(id);
        List<HashMap<String, Object>> classify = pointMapper.getPointInputClassifyInfo(id);
        Map<String, List<HashMap<String, Object>>> inputItems = new HashMap<String, List<HashMap<String, Object>>>();
        if (!classify.isEmpty()) {
            classify.forEach(action -> {
                if (StringUtil.isNotEmpty(action.get("classifyName"))) {
                    if (inputItems.containsKey(action.get("classifyName").toString())) {
                        List<HashMap<String, Object>> list = inputItems.get(action.get("classifyName").toString());
                        list.add(action);
                    } else {
                        List<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                        list.add(action);
                        inputItems.put(action.get("classifyName").toString(), list);
                    }
                } else {
                    if (inputItems.containsKey("其他")) {
                        List<HashMap<String, Object>> list = inputItems.get("其他");
                        list.add(action);
                    } else {
                        List<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                        list.add(action);
                        inputItems.put("其他", list);
                    }
                }
            });
        }
        resp.put("point", point);
        resp.put("inputItems", inputItems);
        resp.put("routes", routes);
        return resp;

    }

    @Override
    public Map queryPointDetailByIdInVersion2(Long id) {
        Map<String, Object> resp = new HashMap<>();
        Map<String, Object> point = pointMapper.getPointById(id);
        List<Map<String, Object>> routes = pointMapper.getPointRoute(id);
        resp.put("point", point);
        resp.put("inputItems", getClassifyRiskDescMap(id));
        resp.put("routes", routes);
        return resp;
    }

    @Override
    public JSONObject getClassifyRiskDescMap(Long id) {
//        List<HashMap<String, Object>> classify = pointMapper.getPointInputClassifyInfo(id);
        List<PointInputItemVo> pointInputItemVo = queryPointClassInputItem(id);
        return getClassifyRiskDescMap(pointInputItemVo);
    }

    @Override
    public JSONObject getClassifyRiskDescMap(List<PointInputItemVo> pointInputItemVo) {
        JSONObject inputItems = new JSONObject();
        if (!pointInputItemVo.isEmpty()) {
            pointInputItemVo.forEach(action -> {
                String classifyName = "其他";
                if (StringUtil.isNotEmpty(action.getClassifyNames())) {
                    classifyName = action.getClassifyNames();
                }
                String riskDesc = XJConstant.DEFAULT_RISKDESC;
                if (StringUtil.isNotEmpty(action.getRiskDesc())) {
                    riskDesc = action.getRiskDesc();
                }
                JSONObject classifyJson;
                if (inputItems.containsKey(classifyName)) {
                    classifyJson = inputItems.getJSONObject(classifyName);
                } else {
                    classifyJson = new JSONObject();
                }
                JSONArray riskDescArr;
                if (classifyJson.containsKey(riskDesc)) {
                    riskDescArr = classifyJson.getJSONArray(riskDesc);
                } else {
                    riskDescArr = new JSONArray();
                }
                if (StringUtils.isEmpty(action.getRiskDesc())) {
                    action.setRiskDesc(riskDesc);
                }
                riskDescArr.add(action);
                classifyJson.put(riskDesc, riskDescArr);
                inputItems.put(classifyName, classifyJson);
            });
        }
        return inputItems;
    }

    @Override
    public Map<String, PointClassifyVo> queryPointClassifyWithInputItemVo(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<String, PointClassifyVo> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            PointClassifyVo pointClassifyVo = new PointClassifyVo();
            BeanUtils.copyProperties(pointClassify, pointClassifyVo);
            pointClassifyVo.setPointInputItemVo(inputItemList);
            classifyInputItemMap.put(pointClassify.getName() + "*" + pointClassify.getOrderNo(), pointClassifyVo);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        return classifyInputItemMap;
    }

    @Override
    public List<PointVo> queryPointInfoList(List<DaoCriteria> criterias) {
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
        List<Point> pointList = iPointDao.findAll(spec);
        List<PointVo> pointVoList = new ArrayList<>();
        for (Point point : pointList) {
            PointVo pointVo = new PointVo();
            BeanUtils.copyProperties(point, pointVo);
            pointVo.setShotNumber(point.getShotMinNumber() + "-" + point.getShotMaxNumber());
            CatalogTree cataTree = catalogTreeDao.findById(point.getCatalogId()).get();
            String catalogName = cataTree != null ? cataTree.getName() : "";
            pointVo.setCatalogName(catalogName);
            List<String> routeNameList = routeMapper.getRouteNameByPointId(point.getId());
            String routeNames = StringUtils.join(routeNameList.toArray(), ",");
            pointVo.setRouteName(routeNames);
            List<String> inputItemNameList = new ArrayList<>();
            for (InputItem inputItem : queryPointInputItem(point.getId())) {
                inputItemNameList.add(inputItem.getName());
            }
            String inputItemName = StringUtils.join(inputItemNameList.toArray(), ",");
            ;
            pointVo.setInputItemName(inputItemName);
            pointVoList.add(pointVo);
        }
        return pointVoList;
    }

    @Override
    public List<PointVo> queryPointInfoListByIds(PointImportQueryParam pointImportQueryParam) {
        return pointMapper.getPointVoByIds(pointImportQueryParam);
    }

    @Override
    public List<HashMap<String, Object>> getSumPtByRole(HashMap<String, Object> paramMap) {
        List<HashMap<String, Object>> content = null;
        if (XJConstant.ADMIN_FLAG.equals(paramMap.get("roleFlag"))) {
            content = pointMapper
                    .getSumPtForAdmin(paramMap.get("orgCode") == null ? null : paramMap.get("orgCode").toString());
        } else if (XJConstant.DEPART_FLAG.equals(paramMap.get("roleFlag"))) {
            content = pointMapper
                    .getSumPtForDept(paramMap.get("orgCode") == null ? null : paramMap.get("orgCode").toString());
        } else if (XJConstant.PERSON_FLAG.equals(paramMap.get("roleFlag"))) {

        }
        List<Map<String, String>> statusEnums = PointStatusEnum.getEnumList();
        List<HashMap<String, Object>> rContent = new ArrayList<>();
        for (Map<String, String> statusEnum : statusEnums) {
            String code = statusEnum.get("value");
            boolean isCreate = true;
            for (HashMap<String, Object> c : content) {
                if (code.equals(c.get("status"))) {
                    isCreate = false;
                    rContent.add(c);
                    break;
                }
            }
            if (isCreate) {
                HashMap<String, Object> temp = new HashMap<>();
                temp.put("name", statusEnum.get("name"));
                temp.put("status", code);
                temp.put("value", 0);
                rContent.add(temp);
            }
        }
        return rContent;
    }

    @Override
    public Map<String, Object> countPointData(String orgCode) {
        Map<String, Object> maps = pointMapper.countPointData(orgCode);
        int over_num = Integer.parseInt(maps.get("over_num").toString());
        int today_num = Integer.parseInt(maps.get("today_num").toString());
        int miss_num = Integer.parseInt(maps.get("miss_num").toString());
        int unfinish_num = Integer.parseInt(maps.get("unfinish_num").toString());
        String passRate = "";
        String passMiss = "";
        if (over_num == 0) {
            passRate = 0 + "";
        } else {
            passRate = getPercent(over_num, (over_num+unfinish_num));
        }
//        today_num = miss_num + today_num;
        if (miss_num == 0) {
            passMiss = 0 + "";
        } else {
            passMiss = getPercent(miss_num, today_num);
        }
        passRate = passRate.replace("%", "");
        passMiss = passMiss.replace("%", "");
        maps.put("passRate",passRate);
        maps.put("passMiss",passMiss);
        return   maps;
    }


    public  String getPercent(int x, int y) {
        double d1 = x * 1.0;
        double d2 = y * 1.0;
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        // 设置保留几位小数，这里设置的是保留两位小数
        percentInstance.setMinimumFractionDigits(2);
        return percentInstance.format(d1 / d2);
    }


    @Override
    public List<HashMap<String, Object>> getSumPtByRoleNew(String orgcode) {
        List<HashMap<String, Object>> content = null;
        content = pointMapper.getSumPtForDeptNew(orgcode);
        List<Map<String, String>> statusEnums = PointStatusEnum.getEnumList();
        List<HashMap<String, Object>> rContent = new ArrayList<>();
        for (Map<String, String> statusEnum : statusEnums) {
            String code = statusEnum.get("value");
            boolean isCreate = true;
            for (HashMap<String, Object> c : content) {
                if (code.equals(c.get("status"))) {
                    isCreate = false;
                    rContent.add(c);
                    break;
                }
            }
            if (isCreate) {
                HashMap<String, Object> temp = new HashMap<>();
                temp.put("name", statusEnum.get("name"));
                temp.put("value", 0);
                rContent.add(temp);
            }
        }
        return rContent;
    }


    @Override
    public HashMap<String, Object> getCheckPtListNew(String orgCode, CommonPageable commonPageable) {
        CheckPtListPageParam param =new CheckPtListPageParam();
        param.setPageNumber(commonPageable.getPageNumber());
        param.setPageSize(commonPageable.getPageSize());
        param.setPageNumber(commonPageable.getPageNumber());
        param.setPageSize(commonPageable.getPageSize());
        param.setOrgCode(orgCode);
        long total = pointMapper.getCheckPointCountNew(param);
        List<CheckPtListBo> content = pointMapper.getCheckPointListNew(param);
        Page<CheckPtListBo> result = new PageImpl<CheckPtListBo>(content, param, total);
        List< HashMap<String, Object>> colModel=new ArrayList<>();

        HashMap<String, Object> temph0 = new HashMap<>();
        temph0.put("fid","nonum");
        temph0.put("dataIndex","nonum");
        temph0.put("name","编号");
        temph0.put("title","编号");
        temph0.put("type","nonum");
        temph0.put("key","nonum");

        HashMap<String, Object> temph1 = new HashMap<>();
        temph1.put("fid","no");
        temph1.put("dataIndex","no");
        temph1.put("name","编号");
        temph1.put("title","编号");
        temph1.put("type","no");
        temph1.put("key","no");
        temph1.put("idVisable",false);
        HashMap<String, Object> temph2 = new HashMap<>();
        temph2.put("fid","name");
        temph2.put("dataIndex","name");
        temph2.put("name","名称");
        temph2.put("title","名称");
        temph2.put("type","name");
        temph2.put("key","name");
//        HashMap<String, Object> temph3 = new HashMap<>();
//        temph3.put("fid","level");
//        temph3.put("dataIndex","level");
//        temph3.put("name","等级");
//        temph3.put("title","等级");
//        temph3.put("type","level");
//        temph3.put("key","level");
        HashMap<String, Object> temph4 = new HashMap<>();
        temph4.put("fid","groupName");
        temph4.put("dataIndex","groupName");
        temph4.put("name","单位");
        temph4.put("title","单位");
        temph4.put("type","groupName");
        temph4.put("key","groupName");
        HashMap<String, Object> temph5 = new HashMap<>();
        temph5.put("fid","realName");
        temph5.put("dataIndex","realName");
        temph5.put("name","责任人");
        temph5.put("title","责任人");
        temph5.put("type","realName");
        temph5.put("key","realName");
        HashMap<String, Object> temph6 = new HashMap<>();
        temph6.put("fid","realTimeStatus");
        temph6.put("dataIndex","realTimeStatus");
        temph6.put("name","状态");
        temph6.put("title","状态");
        temph6.put("type","realTimeStatus");
        temph6.put("key","realTimeStatus");
        HashMap<String, Object> temph7 = new HashMap<>();
        temph7.put("fid","checkTime");
        temph7.put("dataIndex","checkTime");
        temph7.put("name","最新更新时间");
        temph7.put("title","最新更新时间");
        temph7.put("type","checkTime");
        temph7.put("key","checkTime");
        HashMap<String, Object> temph8 = new HashMap<>();
        temph8.put("fid","errorMsg");
        temph8.put("dataIndex","errorMsg");
        temph8.put("name","最新异常内容");
        temph8.put("title","最新异常内容");
        temph8.put("type","errorMsg");
        temph8.put("key","errorMsg");

        colModel.add(temph1);
        colModel.add(temph0);
        colModel.add(temph2);
        // colModel.add(temph3);
        colModel.add(temph4);
        colModel.add(temph5);
        colModel.add(temph6);
        colModel.add(temph7);
        colModel.add(temph8);

        HashMap<String, Object> dataGridMock = new HashMap<>();
        dataGridMock.put("current",result.getNumber()+1);
        dataGridMock.put("total",result.getTotalElements());
        dataGridMock.put("pagination",true);
        dataGridMock.put("totalPage",result.getTotalPages());
        dataGridMock.put("dataList",result.getContent());
        dataGridMock.put("pageSize",result.getSize());

        HashMap<String, Object> DATE = new HashMap<>();
        DATE.put("dataGridMock",dataGridMock);
        DATE.put("colModel",colModel);
        return DATE;
    }












    @Override
    public Page<CheckPtListBo> getCheckPtList(String toke,String product,String appKey,CheckPtListPageParam param) {
        long total = pointMapper.getCheckPointCount(param);
        List<CheckPtListBo> content = pointMapper.getCheckPointList(param);

        //查询用户名称和部门名称

        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet(Lists.transform(content, CheckPtListBo::getRealName));
            userIds.remove(null);
            userIds.remove("");
            Set<String> deptIds = Sets.newHashSet(Lists.transform(content, CheckPtListBo::getGroupName));
            deptIds.remove("");
            deptIds.remove(null);
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds( toke, product, appKey,Joiner.on(",").join(userIds));
            Map<String, String> deptMap =  new HashMap<String,String>();
            if(!CollectionUtils.isEmpty(deptIds)){
                List<LinkedHashMap> deptList = remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey,Joiner.on(",").join(deptIds));
                //deptMap = deptList.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));

                for (int i = 0; i < deptList.size(); i++) {
                	deptMap.put(deptList.get(i).get("sequenceNbr").toString(), deptList.get(i).get("departmentName").toString());
    			}


            }
            Map<String,String> userModelMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId,AgencyUserModel::getRealName ,(k1,k2)->k2));
            Map<String, String> deptMapNew= deptMap;
            List<String> userNames = new ArrayList<>();

            content.forEach(e -> {
                userNames.clear();
                if(e.getRealName()!=null) {
                	List<String> userIds1 = Arrays.asList(e.getRealName().split(","));
                	for(String userId : userIds1){
                		userNames.add(userModelMap.get(userId));
                	}
                	userNames.remove(null);
                	e.setRealName(Joiner.on(",").join(userNames));
                	e.setGroupName(deptMapNew.get(e.getGroupName()));
                }
            });
        }



        Page<CheckPtListBo> result = new PageImpl<CheckPtListBo>(content, param, total);
        return result;
    }

    @Override
    public CheckPtListBo qryPointByID(int pointID) {
        CheckPtListBo point = pointMapper.getCheckPointById(pointID);
        return point;
    }

    @Override
    public List<PointClassify> queryClassByIds(List<Long> ids) {
        return iPointClassifyDao.findAllById(ids);
    }

    @Override
    public void initPointStatus() {
        // TODO Auto-generated method stub
        List<Point> pointList = iPointDao.findAll();
        pointList.forEach(point -> {
            PointStatusCache.getInstance().putPointStatus(point.getId(), point.getStatus());
            ;
        });
    }

    @Override
    public HashMap<String, Object> queryPointPie(HashMap<String, Object> params) {
        return pointMapper.queryPointPie(params);
    }

    @Override
    public List<String> qryPointNoList(List<DaoCriteria> criterias, Long pointId) {
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
        List<Point> pointList = iPointDao.findAll(spec);
        List<String> pointNoList = new ArrayList<>();
        for (Point point : pointList) {
            if (point.getId() != pointId) {
                pointNoList.add(point.getPointNo());
            }
        }
        return pointNoList;
    }

    @Override
    public List<HashMap<String, Object>> queryPointHistogram(HashMap<String, Object> params) {
        return pointMapper.queryPointHistogram(params);
    }

    @Override
    public long getPointCountByOrgCode(String loginOrgCode) {
        return pointMapper.getPointCountByOrgCode(loginOrgCode);
    }

    @Override
    public List<LeavelMovePointVo> queryLeavelPoint(String toke, String product, String appKey,String orgCode, String startTime) {
        List<LeavelMovePointVo> content = pointMapper.queryLeavelPoint(orgCode, startTime);
        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> deptIdSet = new HashSet<>();
        content.forEach(s -> {
            if (s.getChargePerson()!=null&&!"".equals(s.getChargePerson())) {
                set.add(s.getChargePerson());
            }
            if (s.getDepartmentName()!=null&&!"".equals(s.getDepartmentName())) {
                deptIdSet.add(s.getDepartmentName());
            }
        });

        List<String> userList = new ArrayList<>(set);
        List<String> deptList = new ArrayList<>(deptIdSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> deptMap =  new HashMap<String,String>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);

            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds( toke, product, appKey,userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
            	LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile()!=null?agencyUserModel.getMobile():agencyUserModel.getLandlinePhone());
			}

        }
        if(!CollectionUtils.isEmpty(deptList)){
            List<LinkedHashMap> deptList1 = remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey,Joiner.on(",").join(deptList));
            //deptMap = deptList.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));

            for (int i = 0; i < deptList1.size(); i++) {
            	deptMap.put(deptList1.get(i).get("sequenceNbr").toString(), deptList1.get(i).get("departmentName").toString());
			}


        }
        Map<String, String> deptMapNew= deptMap;


        List<String> userNames = new ArrayList<>();
        Map<String, String> finalUserMap = userMap;
        Map<String, String> finalDeptMap = LoginName;
        content.forEach(c -> {
            userNames.clear();
            if(c.getChargePerson()!=null&&!"".equals(c.getChargePerson())){
            	 List<String> userIdsList = Arrays.asList(c.getChargePerson().split(","));
                 for (String userId : userIdsList) {
                     userNames.add(finalUserMap.get(userId));
                 }
                 userNames.remove(null);
                 c.setChargePerson( Joiner.on(",").join(userNames));
            }
           if(c.getDepartmentName()!=null&&!"".equals(c.getDepartmentName())){
        	   c.setDepartmentName(deptMapNew.get(c.getDepartmentName()));
           }


        });
        return content;
    }

    @Override
    public List<Map<String, Object>> getPoints() {
        // TODO Auto-generated method stub
        return pointMapper.getPoints();
    }

    @Override
    public List<Map<String, Object>> queryPointClassifyByRouteIdAndPointId(Long routeId, Long pointId) {
        // TODO Auto-generated method stub
        return pointMapper.queryPointClassifyByRouteIdAndPointId(routeId, pointId);
    }

    @Override
    public List<PointInputItemVo> queryOldPointInputItem(Long pointId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById1(pointId, null);
        Map<Long, PointInputItemVo> itemMap = new HashMap<>();
        for (PointInputItemVo itemVo : inputItemList) {
            itemMap.put(itemVo.getPointItemId(), itemVo);
        }
        List<PointInputItemVo> list = new ArrayList<>();
        itemMap.values().forEach(item -> {
            list.add(item);
        });
        return list;
    }

    public List<PointInputItemVo> queryOldPointInputItemNew(Long pointId,Long classifyId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById1(pointId, classifyId);
        Map<Long, PointInputItemVo> itemMap = new HashMap<>();
        for (PointInputItemVo itemVo : inputItemList) {
            itemMap.put(itemVo.getPointItemId(), itemVo);
        }
        List<PointInputItemVo> list = new ArrayList<>();
        itemMap.values().forEach(item -> {
            list.add(item);
        });
        return list;
    }

    @Override
    public List<String> queryEquipPointItemListByPointId(Long routeId, Long pointId) {
        Long[] longs = new Long[]{pointId};
        List<RoutePoint> list = iRoutePointDao.queryRoutePoint(routeId, longs);
        String excludeItems = list.get(0).getExcludeItems();
        String strings[] = excludeItems.split(",");
        List<String> itemIds = Arrays.asList(strings);
        return itemIds;
    }

    @Override
    public List<PointResponse> getPointConfigDom() {
        // TODO Auto-generated method stub
        return pointMapper.getPointConfigDom();
    }

    // @Override
    // public PointInfoSyn3DRespone pushPointTo3D(long pointId) {
    // List<Map<String,Object>> result = pointMapper.getPointInfoById(pointId);
    // PointInfoSyn3DRespone pointInfoResponse = new PointInfoSyn3DRespone();
    // List<PointUserSyn3DRespone> users = new
    // ArrayList<PointUserSyn3DRespone>();
    // if(!result.isEmpty()){
    // result.forEach(action->{
    // pointInfoResponse.setPointId(getValue(action.get("pointId")));
    // pointInfoResponse.setPointName(getValue(action.get("pointName")));
    // pointInfoResponse.setPointLevel(getValue(action.get("pointLevel")));
    // pointInfoResponse.setStatus(getValue(action.get("status")));
    // pointInfoResponse.setCoordinates(getValue(action.get("coordinates")));
    // pointInfoResponse.setAddress(getValue(action.get("address")));
    // PointUserSyn3DRespone pointUserSyn3DRespone = new
    // PointUserSyn3DRespone();
    // pointUserSyn3DRespone.setUserId(getValue(action.get("userId")));
    // pointUserSyn3DRespone.setUserName(getValue(action.get("userName")));
    // pointUserSyn3DRespone.setOrgCode(getValue(action.get("orgCode")));
    // pointUserSyn3DRespone.setGroupName(getValue(action.get("groupName")));
    // users.add(pointUserSyn3DRespone);
    // });
    // pointInfoResponse.setUsers(users);
    // }
    // List<PointInfoSyn3DRespone> list = new ArrayList<>();
    // list.add(pointInfoResponse);
    // remoteServer.pointInfoPush(list);
    // return pointInfoResponse;
    // }
    //
    // private String getValue(Object value){
    // if(value == null){
    // return "";
    // }
    // return value.toString();
    // }


    @Override
    public List<HashMap<String, Object>> findPointList(String code, String name, String orgCode) {
        // TODO Auto-generated method stub
        return pointMapper.findPointList(orgCode, name, code);
    }

    @Override
    public List<Point> queryPointInfoByParms(List<DaoCriteria> criterias) {
        // TODO Auto-generated method stub
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
        List<Point> point = iPointDao.findAll(spec);
        return point;
    }

    @Override
    public List<PointInputItemVo> queryPointClassInputItem(Long pointId) {
        // TODO Auto-generated method stub
        return pointMapper.getPointClassInputItemById(pointId);
    }

    @Override
    public List<Map<String, Object>> queryAllPointConfig(String loginOrgCode) {
        return pointMapper.queryAllPointConfig(loginOrgCode);
    }

    @Override
    public List<Map<String, Object>> queryEquipPointInputItem(Long pointId) {
        List<Map<String, Object>> content =  pointMapper.queryEquipPointInputItem(pointId);
        content.forEach(e->{
            if(e.get("id")!=null && !StringUtils.isBlank(e.get("id").toString())){
                List<PointInputItemVo> inputItems =  inputItemMapper.queryCustomInputItemByPointId(e.get("id").toString());
                e.put("equipIputDetailData",inputItems);
                e.put("equipIputDetailDataNum",inputItems!=null?inputItems.size():0);
            }
        });
        return content;
    }

//	@Override
//	public PointInfoSyn3DRespone pushPointTo3D(long pointId) {
//		List<Map<String,Object>> result = pointMapper.getPointInfoById(pointId);
//		PointInfoSyn3DRespone pointInfoResponse = new PointInfoSyn3DRespone();
//		List<PointUserSyn3DRespone> users = new ArrayList<PointUserSyn3DRespone>();
//		if(!result.isEmpty()){
//			result.forEach(action->{
//				pointInfoResponse.setPointId(getValue(action.get("pointId")));
//				pointInfoResponse.setPointName(getValue(action.get("pointName")));
//				pointInfoResponse.setPointLevel(getValue(action.get("pointLevel")));
//				pointInfoResponse.setStatus(getValue(action.get("status")));
//				pointInfoResponse.setCoordinates(getValue(action.get("coordinates")));
//				pointInfoResponse.setAddress(getValue(action.get("address")));
//				PointUserSyn3DRespone pointUserSyn3DRespone = new PointUserSyn3DRespone();
//				pointUserSyn3DRespone.setUserId(getValue(action.get("userId")));
//				pointUserSyn3DRespone.setUserName(getValue(action.get("userName")));
//				pointUserSyn3DRespone.setOrgCode(getValue(action.get("orgCode")));
//				pointUserSyn3DRespone.setGroupName(getValue(action.get("groupName")));
//				users.add(pointUserSyn3DRespone);
//			});
//			pointInfoResponse.setUsers(users);
//		}
//		List<PointInfoSyn3DRespone> list = new ArrayList<>();
//		list.add(pointInfoResponse);
//		remoteServer.pointInfoPush(list);
//		return pointInfoResponse;
//	}
//
//	private String getValue(Object value){
//		if(value == null){
//			return "";
//		}
//		return value.toString();
//	}

    @Override
    public Page queryPointList4Route(Long riskSourceId, String pointNo, String name, int current, int size) {
        if (current < 1 || size < 0) {
            throw new RuntimeException("查询条件有误");
        }
        List<Long> structureIdList = null;
        List<Map<String, Object>> list = Collections.EMPTY_LIST;
        // 传入riskSourceId为-2请求的是巡检点区域为空
        if (riskSourceId != null && riskSourceId != -2) {
            LinkedHashMap<String,Object> o = equipFeign.getBuildingTree();
            if(o==null||!"200".equals(o.get("status").toString())) {
                throw new YeeException("获取建筑树出错");
            }
            List<Map<String, Object>> buildingTree = (List<Map<String, Object>>) o.get("result");
            Map<String, Object> node = getAllNodes(buildingTree).stream().filter(map -> riskSourceId.toString().equals(map.get("id"))).findFirst().orElse(null);
            if (node != null) {
                structureIdList = findBuildChildrenIds(node);
            }
        }

        boolean nullRiskSourceId = false;
        if (riskSourceId != null && riskSourceId == -2) {
            nullRiskSourceId = true;
        }

        int total = pointMapper.queryPointCount4Route(structureIdList, pointNo, name, nullRiskSourceId);
        int offset = (current - 1) * size;
        if (total > offset) {
            list = pointMapper.queryPointList4Route(structureIdList, pointNo, name, offset, size, nullRiskSourceId);
        }
        return new PageImpl(list, PageRequest.of(current - 1, size), total);
    }

    @Override
    public Page queryPointList4RouteNew(String bizOrgCode,Long riskSourceId, String pointNo, String name, int current, int size,String companyId) {
        List<Long> structureIdList = null;
        List<Map<String, Object>> list = Collections.EMPTY_LIST;
        // 传入riskSourceId为-2请求的是巡检点区域为空
        if (riskSourceId != null && riskSourceId != -2) {
            LinkedHashMap<String,Object> o = equipFeign.getBuildingTree();
            if(o==null||!"200".equals(o.get("status").toString())) {
                throw new YeeException("获取建筑树出错");
            }
            List<Map<String, Object>> buildingTree = (List<Map<String, Object>>) o.get("result");
            Map<String, Object> node = getAllNodes(buildingTree).stream().filter(map -> riskSourceId.toString().equals(map.get("id"))).findFirst().orElse(null);
            if (node != null) {
                structureIdList = findBuildChildrenIds(node);
            }
        }

        boolean nullRiskSourceId = false;
        if (riskSourceId != null && riskSourceId == -2) {
            nullRiskSourceId = true;
        }

        int total = pointMapper.queryPointCount4RouteNew(bizOrgCode,structureIdList, pointNo, name, nullRiskSourceId,companyId);
        int offset = (current - 1) * size;
        if (total > offset) {
            list = pointMapper.queryPointList4RouteNew(bizOrgCode,structureIdList, pointNo, name, offset, size, nullRiskSourceId,companyId);
        }
        return new PageImpl(list, PageRequest.of(current - 1, size), total);
    }

    private List<Map<String, Object>> getAllNodes(List<Map<String, Object>> buildingTree) {
        List<Map<String, Object>> res = new LinkedList<>();
        if (buildingTree != null && !buildingTree.isEmpty()) {
            res.addAll(buildingTree);
            buildingTree.forEach(building -> {
                List<Map<String, Object>> childrenTree = (List<Map<String, Object>>) building.get("children");
                res.addAll(getAllNodes(childrenTree));
            });
        }
        return res;
    }
    private List<Long> findBuildChildrenIds(Map<String, Object> building) {
        List<Map<String, Object>> buildingTree = getAllNodes(Collections.singletonList(building));
        return buildingTree.stream().map(building123 -> Long.valueOf(building123.get("id").toString())).collect(Collectors.toList());
    }
    @Override
    public List queryPointListByRouteId(Long routeId) {
        if (routeId == null) {
            throw new RuntimeException("查询条件有误");
        }
        List<Map<String, Object>> resList = pointMapper.queryPointListByRouteId(routeId);
        resList.forEach(map -> {
            map.put("routePointItem", Collections.EMPTY_LIST);
        });
        return resList;
    }


    @Override
    public List queryEquipListByPointId(Long pointId) {
        if (pointId == null) {
            throw new RuntimeException("查询条件有误");
        }
        List<Map<String, Object>> resList = pointMapper.queryEquipListByPointId(pointId);
        resList.stream().forEach(item -> {
            item.put("classifyId", ObjectUtils.isEmpty(item.get("classifyId")) ? "" : String.valueOf(item.get("classifyId")));

        });
        return resList;
    }

    @Override
    public List queryItemList4RoutePoint(Long pointId, Long classifyId) {
        if (pointId == null || classifyId == null) {
            throw new RuntimeException("查询条件有误");
        }
        List<Map<String, Object>> resList = pointMapper.queryItemList4RoutePoint(pointId, classifyId);
        return resList;
    }

    @Override
    public LinkedHashMap<String, Object> getRegionTress() {
        return equipFeign.getRegionTress();
    }

    @Override
    public void syncPointClassify(Map<String, Object> map) {
        if (ObjectUtils.isEmpty(map)) {
            log.info("消息内容为空!!!");
            return;
        }

        String method = map.get("method").toString();
        PointClassifySynDto pointClassifySynDto = JSON.parseObject(map.get("data").toString(), PointClassifySynDto.class);
        switch (method) {
            case "DELETE":
                iPointClassifyDao.deleteByOriginalId(pointClassifySynDto.getOriginalId());
                break;
            case "UPDATE":
                List<PointClassify> pointClassifyList = iPointClassifyDao.selectByOriginalId(pointClassifySynDto.getOriginalId());
                if (ObjectUtils.isEmpty(pointClassifyList)) {
                    log.info("数据不存在!");
                }
                pointClassifyList.forEach(pointClassify -> {
                    BeanUtils.copyProperties(pointClassifySynDto, pointClassify,getNullPropertyNames(pointClassifySynDto));
                    iPointClassifyDao.saveAndFlush(pointClassify);
                });
                break;
            default:
                log.info("方法参数错误!!!");
                break;
        }
    }

    /**
     * 获取控制字段列表
     * @param source 对象
     * @return 为空数组
     */
    private static String[] getNullPropertyNames(Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        Set<String> emptyNames = new HashSet<String>();
        for(PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) {
                emptyNames.add(pd.getName());
            }
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

/*13迭代新增列表方法*/
    public IPage<PointVo> queryPointInfoNew(PointQueryVo pointParams, int current ,int size, String loginOrgCode) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Object> page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(current, size);
        current = (current - 1) * size;
        List<Point> pointPage = pointMapper.listByParams(pointParams, current, size);
        int num = pointMapper.listByParamsCount(pointParams);
        List<PointVo> pointVoList = new ArrayList<>();
        for (Point point : pointPage) {
            PointVo pointVo = new PointVo();
            BeanUtils.copyProperties(point, pointVo);
            pointVo.setShotNumber(point.getShotMinNumber() + "-" + point.getShotMaxNumber());

            List<String> classifyNameList = new ArrayList<>();
            List<PointClassify> pointClassifys = iPointClassifyDao.getPointClassifyByPointId(point.getId());
            for (PointClassify pointClassify : pointClassifys) {
                classifyNameList.add(pointClassify.getName());
            }
            String classifynames = StringUtils.join(classifyNameList.toArray(), ",");
            pointVo.setClassifyName(classifynames);
            pointVoList.add(pointVo);
        }
        IPage<PointVo> pointVo = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
        pointVo.setRecords(pointVoList);
        pointVo.setTotal(num);
        pointVo.setCurrent(current);
        pointVo.setSize(size);

        return pointVo;
    }
}
