package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
* 特种设备基本信息-其他信息Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class OtherInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "保险机构")
    /**
    * 保险机构
    */
    private String insuranceOrg;
            @ApiModelProperty(value = "保险到期日")
    /**
    * 保险到期日
    */
    private Date expiryDate;
            @ApiModelProperty(value = "物联网机构（非必填）")
    /**
    * 物联网机构（非必填）
    */
    private String iotOrg;
            @ApiModelProperty(value = "物联网接入标志（非必填）")
    /**
    * 物联网接入标志（非必填）
    */
    private String iotSign;
            @ApiModelProperty(value = "有无监控(有、无)")
    /**
    * 有无监控(有、无)
    */
    private String isMonitor;
            @ApiModelProperty(value = "96333识别码(七位电梯应急救援识别码)")
    /**
    * 96333识别码(七位电梯应急救援识别码)
    */
    private String code96333;



}
