package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_scrap_detail")
@ApiModel(value = "ScrapDetail对象", description = "")
public class ScrapDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "报废单id")
	private Long scrapId;

	@ApiModelProperty(value = "库存明细账id")
	private Long stockDetailId;

	@TableField(exist = false)
	private StockDetail stockDetail;

	@TableField(exist = false)
	private Car car;

	@ApiModelProperty(value = "报废数量")
	private double amount;

	@ApiModelProperty(value = "车辆id")
	private Long carId;

	@ApiModelProperty(value = "原因")
	private String reason;

	@TableField(exist = false)
	private String img;

}
