package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipment;
import com.yeejoin.equipmanage.common.datasync.vo.FireEquipmentVO;
import com.yeejoin.equipmanage.common.dto.EquipmentSpecificDto;
import com.yeejoin.equipmanage.common.dto.FireFightingSystemDto;
import com.yeejoin.equipmanage.common.dto.UserDto;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecific;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.entity.dto.EquipmentSpecificDTO;
import com.yeejoin.equipmanage.common.entity.vo.ComplementCodeVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentSpecificVo;
import com.yeejoin.equipmanage.common.entity.vo.IotIndexInfoVo;
import com.yeejoin.equipmanage.common.entity.vo.SourceNameByEquipSpeIdVO;
import com.yeejoin.equipmanage.common.vo.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/10/29 16:57
 * @since v2.0
 */
public interface IEquipmentSpecificSerivce extends IService<EquipmentSpecific> {

    /**
     * 补码页面查询分页
     *
     * @param equipmentSpecific
     * @return
     */
    IPage<ComplementCodeVO> selectEquipmentSpecific(EquipmentSpecificDTO equipmentSpecific);

    /**
     * 修改单个设备
     * 业务逻辑：修改
     * 如果已经入库数据只需要修改单个设备的信息及入库位置
     * 未入库数据入库,生成入库单，并修改单个设备信息
     *
     * @param equipmentSpecific
     * @param reginParams
     * @return
     */
    EquipmentSpecific updateEquipmentSpecific(EquipmentSpecific equipmentSpecific, ReginParams reginParams, AgencyUserModel agencyUserModel);

    /**
     * 设备报警信息
     *
     * @param id
     * @return
     */
    Map<String, Object> getAll(Long id);

    Map<String, Object> getMaintenanceInfo(String checkDate);

    /**
     * 通过二维码,或者设备id判断装备是否单件录入 false:批量 true单件
     *
     * @param qrCode
     * @return
     */
    boolean equipmentgetIsSingleByQrcode(String qrCode, Long equipmentSpecifticId);

    EquipmentSpecific equipmentByQrcode(String qrCode);

    Boolean delEquipmentSpecific(Long id);

    /**
     * 批量清除调用
     * @param equipmentSpecific 装备信息
     */
    Boolean delEquipmentSpecificByIdNew(EquipmentSpecific equipmentSpecific);

    /**
     * 组装组态使用的卡片数据
     *
     * @param id
     * @return
     */
    Object getOneCard(Long id, String type);

    /**
     * 通过id获取设备区域建筑等信息
     *
     * @param id
     * @return
     */
    SourceNameByEquipSpeIdVO getSourceNameByEquipSpeId(Long id);

    IPage<SourceNameByEquipSpeIdVO> getSourceNameList(IPage page, Long warehouseStructureId, Long sourceId, String equipmentName, String equipmentCode);

    /**
     * 装备实例创建
     *
     * @param equipmentData   装备数据
     * @param selectedOrgInfo 选择的公司
     * @param userInfo        用户信息
     *                        新增单个设备以及性能指标等
     *                        业务逻辑：
     *                        1.单件管理+单个录入+物联编码+位置 = 添加实体设备及指标+入库 （新增数量输入框默认1，不可编辑）
     *                        2.单件管理+单个录入+物联编码 = 添加实体设备及指标（新增数量输入框默认1，不可编辑）
     *                        3.单件管理+多个录入+位置 = 添加实体设备及指标+入库（新增数量输入框默认1，可编辑）
     *                        4.单件管理+多个录入 = 添加实体设备及指标（新增数量输入框默认1，可编辑）
     *                        5.批量管理+只能批量录入+位置 + 录入个数= 添加实体设备及指标+入库 （有个数位置必填）
     *                        6.批量管理+只能批量录入= 添加实体设备及指标
     * @return EquipmentDate
     */
    EquipmentDate equipmentSpecificCreate(EquipmentDate equipmentData, ReginParams selectedOrgInfo, AgencyUserModel userInfo);

    String getEquipSpeTypeByQrcode(String qrCode);

    /**
     * 获取设备详情
     *
     * @param equipmentSpecific
     * @return
     */
    FireEquipment getEquipSpecificDetail(EquipmentSpecific equipmentSpecific);

    /**
     * 获取instanceId和orgCode
     *
     * @param sourceId
     * @return
     */
    FireEquipmentVO getInstanceIdAndOrgCode(Long sourceId);

    void equipSpecificDataSync(Long equipmentId);

    List<FireEquipment> getEquipSpecificDetailsByEquipmentId(Long equipmentId);

    /**
     * 根据系统id获取系统设备集合
     *
     * @param id
     * @param status
     * @param name
     * @return
     */
    List<EquipmentSpecific3dVo> get3dFightingSysEquipList(Long id, Integer status, String name);

    /**
     * 根据系统id分页系统设备集合
     *
     * @param
     * @return
     */
    IPage<EquipmentSpecific3dVo> listPage(Page<EquipmentSpecific3dVo> pageBean, EquipFor3DVO equipment);

    /**
     * 根据系统id，获取系统设备数量统计
     *
     * @param id
     * @param status
     * @param name
     * @return
     */
    List<LinkedHashMap> get3dFightingSysEquipCount(Long id, Integer status, String name);

    /**
     * @param like    设备名称或编码code
     * @param notLike wl_equipment_category，code不包含（右%），多个用英文逗号隔开
     * @param status  wl_stock_detail.status
     * @return
     */
    List<EquipmentOnCarVo> getAirEquipSpecificList(String like, String notLike, Integer status);

    IPage<EquipmentOnCarVo> onCarVoIPage(EquipmentSpecificDto equipmentSpecificDto);

    EquipmentDetailVo getAirEquipSpecificDetail(Long stockDetailId);

    List<UserDto> getEquipSpecificLocationInfo(Long equipmentSpecificId, String[] fieldName);
    Map<String,Double> getEquipLocationInfo(Long equipmentSpecificId);

    /**
     * 根据specificId删除相关数据
     *
     * @param specificId specificId
     * @return Boolean
     */
    Boolean delEquipmentBySpecificId(Long specificId);

    /**
     * 集成页面刷新，发送数据时调用
     *
     * @param systemTypeCode
     */
    void integrationPageSysDataRefresh(String systemTypeCode);

    /**
     * 更新设备表实时指标状态
     *
     * @param indexs
     */
    void updateEquipmentSpecIndexRealtimeData(EquipmentSpecificIndex index);


    List<EquipmentSpecificVo> getEquipAndCarIotcodeByIotcode(String iotCode);

    /**
     * 获取中州环境监测指标详情
     *
     * @return
     */
    Map<String, List<Map<String, String>>> getFessIndexDetails();

    /**

     * 更新redis 统计数据
     */
    void refreshStaData();

    /* 设备绑定摄像头
     *
     * @param videoOnEquipmentSpecificVo
     * @return
     */
    Boolean videoOnEquipmentSpecific(VideoOnEquipmentSpecificVo videoOnEquipmentSpecificVo);
    Boolean delVideoOnEquipmentSpecific(Long equipmentSpecificId,  Long videoId);
    Boolean delVideoOnEquipmentjb(List<String> ids);
    Boolean videoOnEquipmentSpecificbj( Map<String,List<String>>  date);
    /**
     * 根据装备分类code获取装备列表
     * @param code 装备分类逗号隔开
     * @return 装备list
     */
    List<Map<String, Object>> getListByEquipmentCodeJ(String code,String bizOrgCode);
    List<Map<String, Object>> getFirePumpInfoEQ(String code,String bizOrgCode);
    /**
     * 根据装备分类code获取装备列表,id 升序
     * @param code 装备分类逗号隔开
     * @return 装备list
     */
    List<Map<String, Object>> getListByEquipmentCode(String code, String bizOrgCode);

    /**
     * 根据装备id获取物联日志
     * @param iotCode code
     * @param entity 日志
     * @param isTrend 是否遥测 不传默认查遥测遥信
     * @param fieldKey 指标key 不传默认查全部指标
     * @return 物联日志list
     */
    List<IotIndexInfoVo> getIndexInfoList(String iotCode, ResponseModel entity, Integer isTrend, String fieldKey);

    List<Map<String, Object>> normalIndexInfoList(String startDate, String endDate);

    Page<Map<String, Object>> normalIndexInfoListByPage(Page<Map<String, Object>> page, String startDate, String endDate, String systemCode, String name);

    Map<String, Object> getFireAutoSysInfo(String startDate, String endDate);

    Map<String, Object> getPaomoSysInfo(String startDate, String endDate);

    Map<String, Object> getWaterSysInfo(String startDate, String endDate);


    List<Map<String, Object>> getEquipmentStatisticsInfo(String bizOrgCode);

    /**
     * 消防系统物联部件统计
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<FireFightingSystemDto> fireSysIotEquipCount(Page<Map<String, Object>> page, String bizOrgCode);

    /**
     * 系统状态及告警设备统计
     * @param date
     * @param bizOrgCode
     * @return
     */
    List<FireFightingSystemDto> fireSysIotEquipAlarmCount(Date date, String bizOrgCode);

    List<Map> getWater(Long id);

    Map<String,Object> getStationCode(Long id);

}
