package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.PointInputItem;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iPointInputItemDao")
public interface IPointInputItemDao extends BaseDao<PointInputItem, Long> {

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_point_inputitem WHERE id IN (?1)", nativeQuery = true)
	void delPointInputItemById(List<Long> ids);

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_point_inputitem WHERE point_id IN (?1)", nativeQuery = true)
	void deleteByPointId(List<Long> pointIds);

	@Query(value = "SELECT * FROM p_point_inputitem WHERE  point_id = ?1 AND input_item_id = ?2", nativeQuery = true)
	PointInputItem getPointInputItem(Long pointId, Long inputItemId);

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_point_inputitem WHERE point_id = (?1) AND input_item_id IN (?2)", nativeQuery = true)
	void delPointInputItemByItemId(Long pointId, List<Long> inputItemIds);

	@Modifying
	@Transactional
	@Query(value="delete from p_point_inputitem where input_item_id in (?1)", nativeQuery = true)
	void delPointInputItem(List<Long> ids);


	@Query(value = "SELECT * FROM p_point_inputitem WHERE  point_id = ?1 ", nativeQuery = true)
	List<PointInputItem> getPointInputItemByPointId(Long pointId);

	@Query(value = "SELECT * FROM p_point_inputitem WHERE point_id = (?1) AND input_item_id IN (?2)", nativeQuery = true)
	List<PointInputItem> findAllPointInputItemByPointIdAndItemIds(Long pointId, List<Long> inputItemIds);

	@Modifying
	@Transactional
	@Query(value="delete from f_fmea_point_inputitem where point_inputitem_id in (?1)", nativeQuery = true)
	void deleteFmeaRelationByPointInputItemIds(List<Long> pointInputItemIds);

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_point_inputitem WHERE classify_ids IN (?1)", nativeQuery = true)
	PointInputItem deleteClassifyId(Long classifyId);
}
