package com.yeejoin.amos.supervision.business.util;

import com.yeejoin.amos.supervision.business.constants.XJConstant;
import com.yeejoin.amos.supervision.business.vo.CalDateVo;
import com.yeejoin.amos.supervision.core.util.DateUtil;
import com.yeejoin.amos.supervision.core.util.StringUtil;
import com.yeejoin.amos.supervision.dao.entity.Plan;
import com.yeejoin.amos.supervision.exception.YeeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class PlanTaskUtil {
	private static final  Logger log = LoggerFactory.getLogger(PlanTaskUtil.class);
	/**
	 * 重做数据生成
	 * @param plan计划实体
	 * @param beginDate重做开始日期
	 * @param endDate重做结束日期
	 * @return
	 */
	public static CalDateVo reGenPlanTaskData(Plan plan, String strBginDate, String strEndDate){
		CalDateVo vo = CalDateData(strBginDate,strEndDate,plan);
		return vo;		
	}
	
/**
 * 重做数据生成
 * @param strBginDate 前端上送重做开始日期
 * @param strEndDate 前端上送重做结束日期
 * @param plan
 */
	private static CalDateVo CalDateData(String strBginDate, String strEndDate, Plan plan) {
		Boolean flag = true;//是否生成数据标记，默认为是
		CalDateVo vo = new CalDateVo();
		Date beginDate;//前端上送重做开始日期（date类型）
		Date endDate;//前端上送重做结束日期（date类型）
		Date planBegin;//计划开始日期（date类型）
		Date planEnd = null;//计划结束日期（date类型）
		String strPlanEnd = plan.getPlanEnd();//计划开始日期
		String strPlanBegin = plan.getPlanBegin();//计划结束日期
		String isFixDate = plan.getIsFixedDate();
		//时间格式化
		try {
			SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
			beginDate = df.parse(strBginDate);
			endDate = df.parse(strEndDate);
			planBegin = df.parse(strPlanBegin);
			if(strPlanEnd!=null ){
				planEnd = df.parse(strPlanEnd);
			}
		} catch (ParseException e) {
			log.error(e.getMessage(),e);
			throw new YeeException("日期转换失败");
		}
		
		//日期区间判断
		if(endDate.before(planBegin)){//计划未开始
			return null;
		}else if(strPlanEnd!=null && beginDate.after(planEnd)){//无交集
			flag = false;
		}else{//有交集
			if(planEnd == null){
				if(beginDate.getTime()<=planBegin.getTime() && planBegin.getTime() <= endDate.getTime()){
					vo.setBeginDate(strPlanBegin);
					vo.setEndDate(strEndDate);
				}else if(beginDate.getTime() > planBegin.getTime()){
					vo.setBeginDate(strBginDate);
					vo.setEndDate(strEndDate);
				}
			}else{
				if(beginDate.getTime() <= planBegin.getTime() && endDate.getTime() >=  planBegin.getTime() && endDate.getTime() <= planEnd.getTime()){
					vo.setBeginDate(strPlanBegin);
					vo.setEndDate(strEndDate);
				}else if(beginDate.getTime() <= planBegin.getTime() && planEnd.getTime() <= endDate.getTime()){
					vo.setBeginDate(strPlanBegin);
					vo.setEndDate(strPlanEnd);
				}else if(planBegin.getTime() <= beginDate.getTime() && beginDate.getTime() <= planEnd.getTime() && planEnd.getTime() <= endDate.getTime()){
					vo.setBeginDate(strBginDate);
					vo.setEndDate(strPlanEnd);
				}else if(planBegin.getTime() <= beginDate.getTime() && endDate.getTime() <= planEnd.getTime()){
					vo.setBeginDate(strBginDate);
					vo.setEndDate(strEndDate);
				}
			}
		}
		vo.setIsGenData(flag);
		return vo;
		
	}
/**
 * 根据计划分类及计划类型校验合法性
 * @param plan
 * @return
 */
public static Boolean checkMustFile(Plan plan) {
	Boolean flag = true ;//默认合法
	String isFixDate = plan.getIsFixedDate();//是否固定日期
	String planType = plan.getPlanType();//计划类型：日，周，月，年
	int exeInt = plan.getExecuteInterval();//执行间隔：天，周，月
	int exeRate  = plan.getExecuteRate();//频率（区间执行1 2 3 4 6 12，年等分,年计划使用
	String monthType = plan.getMonthType();//月类型：在 、第（月计划使用）
	String whatDay = plan.getWhatDay();//哪一天，周计划和月计划的天使用（可为数组）
	int whatWeek = plan.getWhatWeek();//哪一周（月计划使用）
	int weekDay = plan.getWeekDay();//周的哪一天（月计划使用）
	int beginNum = plan.getWeekBeginNum();//区间执行，周计划使用，第几天开始
	int endNum =  plan.getWeekEndNum();//区间执行，周计划使用，第几天结束
	int dayRate = plan.getDayRate();//执行频率(公共的)
	if(XJConstant.FIX_DATE_YES.equals(isFixDate)){
		if(exeInt <= 0 || dayRate == -1){
			flag = false;
		}else if(XJConstant.PLAN_TYPE_WEEK.equals(planType)){
			if(!com.yeejoin.amos.supervision.core.util.StringUtil.isNotEmpty(whatDay)){
				flag = false;
			}
		}else if(XJConstant.PLAN_TYPE_MONTH.equals(planType)){
			if(!com.yeejoin.amos.supervision.core.util.StringUtil.isNotEmpty(monthType)){
				flag = false;
			}else{
				if(XJConstant.MONTH_TYPE_DAY.equals(monthType) && !com.yeejoin.amos.supervision.core.util.StringUtil.isNotEmpty(whatDay) ){
					flag = false;
				}else if(XJConstant.MONTH_TYPE_AT.equals(monthType)){
					if(whatWeek <= 0 ||weekDay <=0){
						flag = false;
					}
				}
			}
		}
	}else if(XJConstant.FIX_DATE_NO.equals(isFixDate)){
		if(XJConstant.PLAN_TYPE_DAY.equals(planType)){
			if(exeInt <= 0 || dayRate == -1){
				flag = false;
			}
		}else if(XJConstant.PLAN_TYPE_WEEK.equals(planType)){
			if(beginNum <=0 || endNum <= 0){
				flag = false;
			}
		}else if(XJConstant.PLAN_TYPE_YEAR.equals(planType)){
			
			if(exeInt <= 0 || exeRate <=0){
				flag = false;
			}
		}
	}else{
		flag = false;
	}
	return flag;
}
/**
 * 根据频率计算出开始日期及结束日期
 * @param strPlanDegin 
 * @param exeInt 
 * @return
 */
public static List<HashMap<String, String>> changeRateToDate(String strPlanDegin, int exeRate) {
	List<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
	String strYear = strPlanDegin.substring(0, 4);
	int period = 12/exeRate;//频率的间隔
	for(int i=1;i<=exeRate;i++){	
		HashMap<String, String> dateMap = new HashMap<String, String>();
		int beginMonth = 1+(i-1)*period;//开始月
		int endMonth = beginMonth + period-1;
		String tempBegin = "0" + beginMonth;
		String tempEnd = "0" + endMonth;
		String strBeginMonth = tempBegin.substring(tempBegin.length()-2,tempBegin.length());	
		String strEndMonth= tempEnd.substring(tempEnd.length()-2,tempEnd.length());	
		dateMap.put("begin_date", com.yeejoin.amos.supervision.core.util.DateUtil.getStartMonthDate(strYear + strBeginMonth,"yyyy-MM-dd"));
		dateMap.put("end_date", com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(strYear + strEndMonth,"yyyy-MM-dd"));
		list.add(dateMap);	
	}
	return list;
}

/**
 * 计算时间间隔循环次数(以开始时间做间隔开始点)
 * @param dayBegin 开始日期 
 * @param dayEnd 结束日期 
 * @param duration 时长(单位分钟)
 * @param inter 间隔
 * @param error 误差(单位分钟)
 * @param unit  间隔单位 时 分 秒
 * @return
 */
public static List<HashMap<String, Date>> getLast6Time(Date dayBegin, Date dayEnd, int duration, int inter, int error, String unit) {
	Boolean flag = true;
	int i =0;
	List<HashMap<String, Date>> timeList = new ArrayList<HashMap<String, Date>>();
	while(flag){
		Date calBeginTime = PlanTaskUtil.getAddStarDate(dayBegin,duration,inter,unit,i,error);
		Date calEndTime = PlanTaskUtil.getAddEndDateStr(calBeginTime,duration,error);
		if(calBeginTime.getTime() >= dayBegin.getTime() && dayBegin.getTime() <= calEndTime.getTime() && calEndTime.getTime() <= dayEnd.getTime() ){
			HashMap<String, Date> tempMap = new HashMap<String, Date>();
			tempMap.put("BEGIN_TIME", calBeginTime);
			tempMap.put("END_TIME", calEndTime);
			timeList.add(tempMap);
		}else if(calEndTime.getTime() > dayEnd.getTime()){
			flag = false;
		}
		i++;
	}
	return timeList;
}

/**
 * 获得间隔日期
 * @param dayBegin 开始日期 （HH:mm：ss）
 * @param duration 时长（单位分钟）
 * @param inter （间隔）
 * @param unit 间隔的单位，时 分 秒）
 * @param i 倍数
 * @param error  误差
 * @param format 格式化
 * @return
 */
public static Date getAddStarDate(Date dayBegin, int duration, int inter, String unit, int i, int error) {
	Calendar calendar = Calendar.getInstance(); 
	calendar.setTime(dayBegin);
	for (int j = 0; j < i; j++) {
		if (XJConstant.INTERVAL_UNIT_HOUR.equals(unit)) {
			calendar.add(Calendar.HOUR_OF_DAY, inter);
		} else if (XJConstant.INTERVAL_UNIT_MINUTE.equals(unit)) {
			calendar.add(Calendar.MINUTE, inter);
		} else if (XJConstant.INTERVAL_UNIT_SECOND.equals(unit)) {
			calendar.add(Calendar.SECOND, inter);
		}
	}
	calendar.add(Calendar.MINUTE, (-1)*error);
	return  calendar.getTime();
}
/**
 * 获得间隔日期
 * @param dayBegin 开始日期 （HH:mm：ss）
 * @param duration 工作时长(分钟)
 * @param error 误差(分钟)
 * @return
 */
public static Date getAddEndDateStr(Date dayDegin, int duration, int error) {
	Calendar calendar = Calendar.getInstance(); 
	calendar.setTime(dayDegin);
	calendar.add(Calendar.MINUTE,duration);
	calendar.add(Calendar.MINUTE, 2*error);
	return  calendar.getTime();	
}
/**
 * 生成执行主表数据(开始日期，结束日期)
 * @param plan
 * @param vo
 * @return
 */
public static List<HashMap<String, Date>> genExeDate(Plan plan, CalDateVo vo,String flag) {
	String isFixDate = plan.getIsFixedDate();//是否固定日期 0-否 （时间区间内执行，可夸日） 1-是（一天内执行）
	String planType = plan.getPlanType();//计划类型：1-日，2-周，3-月，4-年
	int firstFlag = plan.getFirstFlag();//首次标记
	String strPlanDegin = plan.getPlanBegin();//计划开始日期
	int exeInt = plan.getExecuteInterval();//执行间隔：天，周，月，
	int exeRate  = plan.getExecuteRate();//频率（区间执行1 2 3 4 6 12，年等分,年计划使用
	String monthType = plan.getMonthType();//月类型：在 、第（月计划使用）
	String whatDay = plan.getWhatDay();//那一天，周计划和月计划的天使用（可能是分隔符数组，如："1,2,3"）
	int whatWeek = plan.getWhatWeek();//哪一周（月计划使用）
	int weekDay = plan.getWeekDay();//周的哪一天（月计划使用）
	int beginNum = plan.getWeekBeginNum();//区间执行，周计划使用，第几天开始
	int endNum =  plan.getWeekEndNum();//区间执行，周计划使用，第几天结束
	String strBeginDate = vo.getBeginDate();//重做开始日期
	String strEndDate = vo.getEndDate();//重做结束日期
	SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
	Date planDegin;
	Date exeBeginDate;
	Date exeEndDate;
	try {
		exeBeginDate = df.parse(strBeginDate);
		exeEndDate = df.parse(strEndDate);
		planDegin = df.parse(strPlanDegin);
	} catch (ParseException e) {
		throw new YeeException("格式转换失败");
	}
	Date exeDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(planDegin, 0);//执行开始基准时间，计划的开始时间
	int init = 0;//累加值
	Date calDate = exeDate;//计算日期
	List<HashMap<String, Date>> dateList = new ArrayList<HashMap<String, Date>>();
	Date weekDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalWeekDate(exeDate, 0);//上周周日
	Date mounthEndDate = com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(exeDate, 0);//上月月末日期
	Date mounthFirstDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(mounthEndDate, 1);//间隔月月初日期
	if(XJConstant.FIX_DATE_YES.equals(isFixDate)){
		String[] strArr = (!com.yeejoin.amos.supervision.core.util.StringUtil.isNotEmpty(whatDay))?null: whatDay.split(",");//哪一天执行
		while(calDate.getTime()<= exeBeginDate.getTime() || calDate.getTime() <= exeEndDate.getTime() ){
			HashMap<String, Date> dateMap = new HashMap<String, Date>();
			if(XJConstant.PLAN_TYPE_DAY.equals(planType)){//日计划				
				if(calDate.getTime() >= exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime()){
					dateMap.put("begin_date", calDate);
					dateMap.put("end_date", calDate);
					dateMap.put("next_gen_date", calDate);
					dateList.add(dateMap);
				}
				init = init + exeInt;
				calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(exeDate,init);
			}else if(XJConstant.PLAN_TYPE_WEEK.equals(planType)){//周计划
				for(String str :strArr){
					HashMap<String, Date> tempMap = new HashMap<String, Date>();
					int inter = Integer.parseInt(str);  
					calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(weekDate,inter);
					if(calDate.getTime() >= exeDate.getTime() && (calDate.getTime()>=exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime())){
						tempMap.put("begin_date", calDate);
						tempMap.put("end_date", calDate);
						tempMap.put("next_gen_date", calDate);
						dateList.add(tempMap);
					}
				}			
				init = init + exeInt;
				weekDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalWeekDate(exeDate,init);
			}else if(XJConstant.PLAN_TYPE_MONTH.equals(planType)){//月计划
				if(XJConstant.MONTH_TYPE_DAY.equals(monthType)){//第几天
					calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(mounthEndDate, Integer.parseInt(whatDay));
					if(calDate.getTime() >= exeDate.getTime() && (calDate.getTime()>=exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime())){
						dateMap.put("begin_date", calDate);
						dateMap.put("end_date", calDate);
						dateMap.put("next_gen_date", calDate);
						dateList.add(dateMap);
					}
					init = init + exeInt;
					mounthEndDate = com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(exeDate, init);
				}else if(XJConstant.MONTH_TYPE_AT.equals(monthType)){//在第几周第几天
					calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntMonthWeekDate(mounthFirstDate,whatWeek,weekDay) ;
					if(calDate.getTime() >= exeDate.getTime() && (calDate.getTime()>=exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime())){
						dateMap.put("begin_date", calDate);
						dateMap.put("end_date", calDate);
						dateMap.put("next_gen_date", calDate);
						dateList.add(dateMap);
					}
					init = init + exeInt;			
					mounthFirstDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(exeDate, init), 1);
				}
			} else {
				return null;
			}
		}
	}else if(XJConstant.FIX_DATE_NO.equals(isFixDate)){
		List<HashMap<String, String>> yearList = new ArrayList<HashMap<String, String>>();
		while(calDate.getTime()<= exeBeginDate.getTime() || calDate.getTime() <= exeEndDate.getTime() ){
			HashMap<String, Date> dateMap = new HashMap<String, Date>();
			if(XJConstant.PLAN_TYPE_DAY.equals(planType)){//日计划	
				if(calDate.getTime() >= exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime()){
					dateMap.put("begin_date", calDate);
					dateMap.put("end_date",calDate);
					dateMap.put("next_gen_date", calDate);
					dateList.add(dateMap);
				}
				init = init + exeInt;
				calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(exeDate,init);
			}else if(XJConstant.PLAN_TYPE_WEEK.equals(planType)){//周计划
				calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(weekDate,beginNum);
				if ((calDate.getTime() <= exeBeginDate.getTime() && exeBeginDate.getTime() <= com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(weekDate, endNum).getTime())
						|| (calDate.getTime() >= exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime())) {
					dateMap.put("begin_date", calDate);
					dateMap.put("end_date", com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(weekDate, endNum));
					dateMap.put("next_gen_date", com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(calDate, exeInt * 7 - 1));
					dateList.add(dateMap);
				}		
				init = init + exeInt;
				weekDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalWeekDate(exeDate,init);
			}else if(XJConstant.PLAN_TYPE_MONTH.equals(planType)){//月计划	
				calDate = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(mounthEndDate,1);
				if((calDate.getTime() <= exeBeginDate.getTime() && exeBeginDate.getTime() <= com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(calDate,1).getTime())
						|| (calDate.getTime() >= exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime())){			
					dateMap.put("begin_date", calDate);
					dateMap.put("end_date", com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(calDate,1));
					dateMap.put("next_gen_date", com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(calDate,1));
					dateList.add(dateMap);
				}			
				init = init + 1;
				mounthEndDate = com.yeejoin.amos.supervision.core.util.DateUtil.getEndMonthDate(exeDate,init);
			}else if(XJConstant.PLAN_TYPE_YEAR.equals(planType)){//年计划
				yearList.clear();
				yearList = PlanTaskUtil.changeRateToDate(strPlanDegin,exeRate); 
				for(int i=0;i<yearList.size();i++){
					HashMap<String, Date> tempMap = new HashMap<String, Date>();
					String beginDate = yearList.get(i).get("begin_date");
					String endDate =  yearList.get(i).get("end_date");
					Date endDayOfYear ;//年末日期
					Date dateYear;
					try {
						calDate = df.parse(beginDate);
						dateYear = df.parse(endDate);
						endDayOfYear = com.yeejoin.amos.supervision.core.util.DateUtil.getLastDayOfYearDate(dateYear);//本年年末日期
					} catch (ParseException e) {
						throw new YeeException("日期格式化失败");
					}
					if((calDate.getTime() <= exeBeginDate.getTime() && exeBeginDate.getTime() <= dateYear.getTime()) 
							|| (calDate.getTime() >= exeBeginDate.getTime() && calDate.getTime() <= exeEndDate.getTime())){
						tempMap.put("begin_date", calDate);
						tempMap.put("end_date",dateYear);
						tempMap.put("next_gen_date",endDayOfYear.getTime() == dateYear.getTime() ? com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalDate(com.yeejoin.amos.supervision.core.util.DateUtil.getFirstDayOfYearDate(com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalYearDate(calDate,exeInt)),-1):dateYear);
						dateList.add(tempMap);
					}else if(calDate.getTime() > exeEndDate.getTime()){
						break;
					}	
				}				
				init = init + exeInt;
				strPlanDegin = com.yeejoin.amos.supervision.core.util.DateUtil.getIntervalYearDate(exeDate,init);
			} else {
				return null;
			}
		}
	}

	return dateList;
}


/**
 * 生成完整时间
 * @param list 8位日期list
 * @param plan 重做的计划信息
 * @return
 */
public static List<HashMap<String, Object>> genWholeExeDate(List<HashMap<String, Date>> list, Plan plan) {
	if(list == null || list.size()<=0 ){
		return null;
	}
	String isFixDate = plan.getIsFixedDate();//是否固定日期
	String planType = plan.getPlanType();//计划类型：日，周，月，年
	Date dayBegin = plan.getDayBegin();//开始时间
	Date dayEnd = plan.getDayEnd();//结束时间
	List<HashMap<String, Object>> timeList =  new ArrayList<HashMap<String, Object>>(); 
	if(XJConstant.FIX_DATE_YES.equals(isFixDate)){
		timeList = genTimeByRate(plan,list);
	}else if (XJConstant.FIX_DATE_NO.equals(isFixDate))
		if (XJConstant.PLAN_TYPE_DAY.equals(planType)) {// 日计划
			timeList = genTimeByRate(plan,list);
		}else {// 周，月计划,年计划
			for(int i= 0;i<list.size();i++){
				HashMap<String, Object> tempMap = new HashMap<String, Object>();
				Date beginDate = list.get(i).get("begin_date");
				Date endDate = list.get(i).get("end_date");
				Date next_gen_date = list.get(i).get("next_gen_date");
				String strBeginTime = com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(beginDate,"yyyy-MM-dd") +" "+ com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(dayBegin,"HH:mm:ss");
				String strEndTime = com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(endDate,"yyyy-MM-dd") +" "+ com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(dayEnd,"HH:mm:ss");
				tempMap.put("BEGIN_TIME", strBeginTime);
				tempMap.put("END_TIME", strEndTime);
				tempMap.put("NEXT_GEN_DATE", com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(next_gen_date,"yyyy-MM-dd"));
				timeList.add(tempMap);
			}
		}
	
	return timeList;
}
/**
 * 生成执行时间按照每天频率
 * @param plan
 * @param list
 * @return
 */
private static List<HashMap<String, Object>> genTimeByRate(Plan plan,List<HashMap<String, Date>> list) {
	int dayRate = plan.getDayRate();//0-1次，1-多次
	String dayTime = plan.getDayTime();//开始时间（执行频率为一次时，使用）
	int inter = plan.getDayInterval();//执行间隔（每天执行频率为多次时使用）
	int duration = plan.getDuration();//工作时长，（执行频率为一次时，使用）
	String unit = plan.getDayIntervalUnit();//执行间隔单位：小时，分钟，秒
	Date dayBegin = plan.getDayBegin();//开始时间（每天执行频率为多次时使用）
	Date dayEnd = plan.getDayEnd();//结束时间（每天执行频率为多次时使用）
	int  error = plan.getError();//允许误差
	List<HashMap<String, Object>> timeList =  new ArrayList<HashMap<String, Object>>(); 
	if(dayRate == XJConstant.DAY_RATE_ONE){
		for(int i= 0;i<list.size();i++){
			HashMap<String, Object> tempMap = new HashMap<String, Object>();
			Date beginDate = list.get(i).get("begin_date");
			Date next_gen_date = list.get(i).get("next_gen_date");
			String strBeginTime = com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(beginDate,"yyyy-MM-dd") +" "+ dayTime;
			String strEndTime = com.yeejoin.amos.supervision.core.util.DateUtil.getIntMinStrDate(strBeginTime,duration,"yyyy-MM-dd HH:mm:ss");
			tempMap.put("BEGIN_TIME", strBeginTime);
			tempMap.put("END_TIME", strEndTime);
			tempMap.put("NEXT_GEN_DATE", com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(next_gen_date,"yyyy-MM-dd"));
			timeList.add(tempMap);
		}
		
	}else if(dayRate == XJConstant.DAY_RATE_MANY){			
		List<HashMap<String, Date>> last6Timelist =  PlanTaskUtil.getLast6Time(dayBegin,dayEnd,duration,inter,error,unit);//循环次数
		if(last6Timelist != null && last6Timelist.size() > 0){
			for(int i= 0;i<list.size();i++){		
				Date beginDate = list.get(i).get("begin_date");
				Date next_gen_date = list.get(i).get("next_gen_date");
				for(HashMap<String, Date> map :last6Timelist){
					HashMap<String, Object> tempMap = new HashMap<String, Object>();
					String strBeginTime = com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(beginDate,"yyyy-MM-dd") +" "+ com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(map.get("BEGIN_TIME"),"HH:mm:ss");
					String strEndTime = com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(beginDate,"yyyy-MM-dd") +" "+ com.yeejoin.amos.supervision.core.util.DateUtil.formatDatrToStr(map.get("END_TIME"),"HH:mm:ss");
					tempMap.put("BEGIN_TIME", strBeginTime);
					tempMap.put("END_TIME", strEndTime);
					tempMap.put("NEXT_GEN_DATE", DateUtil.formatDatrToStr(next_gen_date,"yyyy-MM-dd"));
					timeList.add(tempMap);
				}
			}
			
		}
	}
	return timeList;
}
/**
 * 生成含有人员信息的日期执行数据
 * @param timeList
 * @param plan
 * @return
 */
public static List<HashMap<String, Object>> genWholeExeData(List<HashMap<String, Object>> timeList, Plan plan) {
	if(timeList == null || timeList.size()<=0 ){
		return null;
	}
	String users = plan.getUserId();
	String userNames = plan.getUserName();
	List<HashMap<String, Object>> wholeList = new ArrayList<HashMap<String, Object>>();
	if(com.yeejoin.amos.supervision.core.util.StringUtil.isNotEmpty(users) && StringUtil.isNotEmpty(userNames)){
		String[] userArr = users.split(",");
		String[] userNameArr = userNames.split(",");
		for (HashMap<String, Object> stringObjectHashMap : timeList) {
			HashMap<String, Object> tempMap = new HashMap<>();
			Object strBeginTime = stringObjectHashMap.get("BEGIN_TIME");
			Object strEndTime = stringObjectHashMap.get("END_TIME");
			Object nextGenDate = stringObjectHashMap.get("NEXT_GEN_DATE");
			tempMap.put("BEGIN_TIME", strBeginTime);
			tempMap.put("END_TIME", strEndTime);
			tempMap.put("NEXT_GEN_DATE", nextGenDate);
			if (plan.getIsSingleExecution()) {
				for (int i = 0; i< userArr.length ; i++) {
					if (!ObjectUtils.isEmpty(userArr)) {
						HashMap<String, Object> temp;
						String user = userArr[i];
						temp = (HashMap<String, Object>) tempMap.clone();
						temp.put("USER_ID", user);
						//冗余用户名称，用户名称在计划创建时进行插入
						temp.put("USER_NAME", userNameArr.length - i >= 1 ? userNameArr[i] : "");
						wholeList.add(temp);
					}
				}
			} else {
				HashMap<String, Object> temp;
				temp = (HashMap<String, Object>) tempMap.clone();
				temp.put("USER_ID", users);
				temp.put("USER_NAME", plan.getUserName());
				wholeList.add(temp);
			}
		}	
	}else{
		wholeList = timeList;
	}
	return wholeList;
}

/**
 * 计算日期所在频率的启示日期
 * @param strPlanDegin
 * @param exeRate
 * @param df
 * @return
 */
public static Date getYearCalDate(String strPlanDegin, int exeRate,SimpleDateFormat df) {
	List<HashMap<String, String>> yearList =  PlanTaskUtil.changeRateToDate(strPlanDegin,exeRate); 
	Date calDate = null ;
	for(int i=0;i<yearList.size();i++){
		String beginDateStr = yearList.get(i).get("begin_date");
		String endDateStr =  yearList.get(i).get("end_date");
		Date beginDate;
		Date endDate;
		Date planBegin;
		try {
			beginDate = df.parse(beginDateStr);
			endDate = df.parse(endDateStr);
			planBegin = df.parse(beginDateStr);
		} catch (ParseException e) {
			throw new YeeException("日期格式化失败");
		}	
		if(planBegin.getTime() >= beginDate.getTime() && planBegin.getTime() <= endDate.getTime()){
			calDate = planBegin;
			break;
		}
	}
	return calDate;
}
}
