package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.elevator.api.dto.TzsCitInfoDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.TzsCitInfo;
import com.yeejoin.amos.boot.module.elevator.api.mapper.TzsCitInfoMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.ITzsCitInfoService;
import com.yeejoin.amos.boot.module.elevator.api.vo.TzsCitInfoVo;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 *  服务实现类
 *
 * @author duanwei
 * @date 2022-12-19
 */
@Service
public class TzsCitInfoServiceImpl extends BaseService<TzsCitInfoDto, TzsCitInfo, TzsCitInfoMapper> implements ITzsCitInfoService {

    @Value("${duty.seats.role.ids}")
    private String dutySeatsRoleIds;

    @Autowired
    private RedisUtils redisUtils;

    /**
     *  获取值班所有人员列表
     */
    @Override
    public List<AgencyUserModel> getUserList(){
        ReginParams regionParam = this.getReginParams();
        Long companyId = regionParam.getCompany().getSequenceNbr();
        String[] roleIds = dutySeatsRoleIds.split(",");
        //通过roleIds拿到该对应的人员
        FeignClientResult<List<AgencyUserModel>> userListResult = Privilege.agencyUserClient.queryByCompanyId(companyId,null,null,null);
        List<AgencyUserModel> userList = userListResult.getResult();
        // 排除非系统中人员
        userList = userList.stream().filter(u -> {
            AgencyUserModel agencyUser = Privilege.agencyUserClient.queryByUserId(u.getUserId()).getResult();
            Set<Long> set = new HashSet<>(agencyUser.getOrgRoleSeqs().get(companyId));
            if(!ValidationUtil.isEmpty(set)) {
                for (int i = 0; i < roleIds.length; i++) {
                    if (set.contains(Long.valueOf(roleIds[i]))) {
                        return true;
                    }
                }
            }
            return false;
        }).collect(Collectors.toList());

        return userList;
    }

    @Override
    public String saveOrUpdateInfo(TzsCitInfo tzsCitInfo){
        //校验
        String massage = "",code = "",extphone  = "";
        TzsCitInfo citInfo = this.getById(tzsCitInfo.getSequenceNbr());
        if(!ValidationUtil.isEmpty(citInfo)){
            code = citInfo.getCode();
        }
        if(ValidationUtil.isEmpty(tzsCitInfo.getSequenceNbr())) {
            if (!ValidationUtil.isEmpty(tzsCitInfo.getCtiUserId())) {
                if (!ValidationUtil.isEmpty(this.list(new LambdaQueryWrapper<TzsCitInfo>().eq(TzsCitInfo::getCtiUserId, tzsCitInfo.getCtiUserId())))) {
                    massage = "该用户已有坐席账号，不可重复添加！";
                    return massage;
                }
            }
        }
        if(!code.equals(tzsCitInfo.getCode())) {
            if (!ValidationUtil.isEmpty(this.list(new LambdaQueryWrapper<TzsCitInfo>().eq(TzsCitInfo::getCode, tzsCitInfo.getCode())))) {
                massage = "登录坐席参数code已存在，不可重复添加！";
                return massage;
            }
        }
        // 多个坐席可绑定一个话机，因此屏蔽以下代码
//        if(!extphone.equals(tzsCitInfo.getExtphone())) {
//            if (!ValidationUtil.isEmpty(this.list(new LambdaQueryWrapper<TzsCitInfo>().eq(TzsCitInfo::getExtphone, tzsCitInfo.getExtphone())))) {
//                massage = "登录坐席参数extphone已存在，不可重复添加！";
//                return massage;
//            }
//        }

        //保存数据
        if(!ValidationUtil.isEmpty(tzsCitInfo.getCtiUserId())) {
            AgencyUserModel agencyUser = Privilege.agencyUserClient.queryByUserId(String.valueOf(tzsCitInfo.getCtiUserId())).getResult();
            tzsCitInfo.setCtiUserName(agencyUser.getRealName());
            tzsCitInfo.setRegionCode(agencyUser.getCompanys().iterator().next().getCompanyCode());
        }
        this.saveOrUpdate(tzsCitInfo);
        return null;
    }

    /**
     * 列表数据导出
     *
     * @param response 响应
     * @param ids      数据id
     */
    @Override
    public void export(HttpServletResponse response, List<String> ids) {
        LambdaQueryWrapper<TzsCitInfo> lambda = new QueryWrapper<TzsCitInfo>().lambda();
        lambda.in(TzsCitInfo::getSequenceNbr, ids);
        List<TzsCitInfo> experts = this.baseMapper.selectList(lambda);
        List<TzsCitInfoVo> exportData = JSON.parseArray(JSON.toJSONString(experts), TzsCitInfoVo.class);
        ExcelUtil.createTemplate(response, "坐席数据", "坐席数据", exportData, TzsCitInfoVo.class, null, false);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ResponseModel<Object> expertDataImport(MultipartFile file, AgencyUserModel userModel) {
        try {
            InputStream inputStream = file.getInputStream();
            ExcelReader excelReader = EasyExcel.read(inputStream).build();
            List<ReadSheet> sheetList = excelReader.excelExecutor().sheetList();

            ReadSheet sheet = sheetList.get(0);
            if (ValidationUtil.isEmpty(sheet)) {
                throw new BadRequest("Excel导入模板有误，请重写下载导入！");
            }

            ArrayList<TzsCitInfo> dataList = new ArrayList<>();

            EasyExcel.read(file.getInputStream(), TzsCitInfoVo.class, new AnalysisEventListener<TzsCitInfoVo>() {
                @Override
                public void invoke(TzsCitInfoVo data, AnalysisContext context) {
                    TzsCitInfo citInfo = JSON.parseObject(JSON.toJSONString(data), TzsCitInfo.class);
                    AgencyUserModel agencyUser = Privilege.agencyUserClient.queryByUserId(String.valueOf(data.getCtiUserId())).getResult();
                    if (agencyUser == null){
                        throw new BadRequest("导入坐席人员userId错误！");
                    }
                    citInfo.setCtiUserName(agencyUser.getRealName());
                    citInfo.setRegionCode(agencyUser.getCompanys().iterator().next().getCompanyCode());
                    citInfo.setRecDate(new Date());
                    dataList.add(citInfo);
                }

                @Override
                public void doAfterAllAnalysed(AnalysisContext context) {
                }
            }).headRowNumber(1).sheet().doRead();

            excelReader.finish();

            // 保存数据
            this.saveOrUpdateBatch(dataList);

            return ResponseHelper.buildResponse("success");
        } catch (Exception e) {
            throw new BadRequest(e.getMessage());
        }
    }

    /**
     * 用户单位信息redis获取
     **/
    public ReginParams getReginParams() {
        return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
    }
}
