package com.yeejoin.amos.boot.module.jg.api.dto;

import cn.hutool.core.date.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author Administrator
 * code 生成参数类
 */
@Data
@ApiModel(value = "code生成参数类")
public class CodeGenerateDto {

    @ApiModelProperty(value = "设备种类")
    private String equList;


    @ApiModelProperty(value = "设备类别")
    private String equCategory;


    @ApiModelProperty(value = "设备品种")
    private String equDefine;


    @ApiModelProperty(value = "制造日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date produceDate;


    @ApiModelProperty(value = "审批机构所在地行政区域代码")
    private String receiveCompanyCode;

    /**
     * 获取年
     * @return 制造日期所在年
     */
    public String getYear() {
        return DateUtil.year(produceDate) + "";
    }

    /**
     * 获得设备基本代码
     * @return 设备基本代码
     */
    public String getEquipBaseCode() {
        return StringUtils.isNotEmpty(equDefine) ? equDefine : equCategory;
    }

}
