package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.equipTransfer;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipTransfer;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipTransferEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipTransferEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipTransferServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class EquipTransferEditUpdateService {

    private final JgEquipTransferServiceImpl mainService;

    private final JgEquipTransferEqServiceImpl eqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgEquipTransfer JgEquipTransfer = getOneByApplyNoSingle(applyNo);
        List<JgEquipTransferEq> eqs = eqService.list(new LambdaQueryWrapper<JgEquipTransferEq>().eq(JgEquipTransferEq::getEquipTransferId, JgEquipTransfer.getSequenceNbr()).select(JgEquipTransferEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgEquipTransferEq::getEquId).collect(Collectors.toSet());
    }

    public JgEquipTransfer getOneByApplyNo(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgEquipTransfer>().eq(JgEquipTransfer::getApplyNo, applyNo));
    }

    private JgEquipTransfer getOneByApplyNoSingle(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgEquipTransfer>().eq(JgEquipTransfer::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgEquipTransfer::getProjectContraptionSeq));
    }

    public Set<String> getProIdsByApplyNo(String applyNo) {
        JgEquipTransfer jgEquipTransfer = getOneByApplyNoSingle(applyNo);
        String projectContraptionSeq = jgEquipTransfer.getProjectContraptionSeq();
        Set<String> proIds = new HashSet<>();
        proIds.add(projectContraptionSeq);
        return proIds;
    }

}