package com.yeejoin.amos.patrol.business.dao.repository;

import com.yeejoin.amos.patrol.dao.entity.Check;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("checkDao")
public interface ICheckDao extends BaseDao<Check, Long> {

	Check findByPlanTaskIdAndPointId(Long planTaskId,Long pointId);

	@Modifying
	@Query("delete from Check c where c.id in (:ids)")
	int deleteBatch(@Param("ids") List<Long> ids);

	@Modifying
	@Query("select c.pointId from Check c where c.id in (:ids)")
	List<Long> getPointIdList(@Param("ids") List<Long> ids);


	Check getById(Long id);
}
