package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.yeejoin.amos.api.openapi.face.model.AbstractBaseModel;
/**
 * 施工信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidConstructionInfoDto", description="施工信息表Dto")
public class ConstructionInfoModel extends AbstractBaseModel {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "$column.comments")
    private String instanceId;
    @ApiModelProperty(value = "$column.comments")
    private String status;
    @ApiModelProperty(value = "施工类型")
    private String constructionType;
    @ApiModelProperty(value = "施工单位统一社会信用代码")
    private String uscUnitCreditCode;
    @ApiModelProperty(value = "施工单位名称")
    private String uscUnitName;
    @ApiModelProperty(value = "施工时间")
    private Date uscDate;

    @ApiModelProperty(value = "安装/改造/移装告知ID")
    private String uscInformId;

}
