package com.yeejoin.amos.boot.module.elevator.api.dto;

import java.util.Date;
import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.TzsJgFile;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备基本信息-制造信息Dto
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
public class TzsJgProduceInfoDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	/**
	 * id
	 */
	private Long sequenceNbr;
	@ApiModelProperty(value = "设备唯一标识码")
	/**
	 * 设备唯一标识码
	 */
	private String sequenceCode;
	@ApiModelProperty(value = "监管系统唯一编码")
	/**
	 * 监管系统唯一编码
	 */
	private String superviseCode;
	@ApiModelProperty(value = "制造单位统一社会信用代码")
	/**
	 * 制造单位统一社会信用代码
	 */
	private String produceUnitCreditCode;
	@ApiModelProperty(value = "制造单位名称")
	/**
	 * 制造单位名称
	 */
	private String produceUnitName;
	@ApiModelProperty(value = "制造许可编号")
	/**
	 * 制造许可编号
	 */
	private String produceLicenseNum;
	@ApiModelProperty(value = "出厂编号")
	/**
	 * 出厂编号
	 */
	private String factoryNum;
	@ApiModelProperty(value = "制造日期")
	/**
	 * 制造日期
	 */
	private Date produceDate;
	@ApiModelProperty(value = "制造日期")
	/**
	 * 制造日期
	 */
	private String produceDateStr;
	@ApiModelProperty(value = "是否进口(是、否)")
	/**
	 * 是否进口(是、否)
	 */
	private String imported;
	@ApiModelProperty(value = "制造国")
	/**
	 * 制造国
	 */
	private String produceCountry;
	@ApiModelProperty(value = "监督检验ID")
	/**
	 * 监督检验ID
	 */
	private String inspectionId;
	@ApiModelProperty(value = "型式试验ID")
	/**
	 * 型式试验ID
	 */
	private String typeTestId;
	@ApiModelProperty(value = "同步时间")
	/**
	 * 同步时间
	 */
	private Date syncDate;
	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	/**
	 * 同步状态（0-新增 1-更新 2-删除）
	 */
	private Integer syncState;
	@ApiModelProperty(value = "对接公司编码")
	/**
	 * 对接公司编码
	 */
	private String appId;
	@ApiModelProperty(value = "创建时间")
	/**
	 * 创建时间
	 */
	private Date recDate;
	@ApiModelProperty(value = "操作人员")
	/**
	 * 操作人员
	 */
	private String recUserId;

	private List<TzsJgFile> produceStandard;

	private List<TzsJgFile> productCertificate;

	private List<TzsJgFile> iumInstructions;

	private List<TzsJgFile> supervisionCert;

	private List<TzsJgFile> ceCert;
}
