package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.*;

import java.util.Date;

/**
 * 三环系统-车辆信息表
 *
 * @author system_generator
 * @date 2024-11-08
 */
@Data
@ApiModel(value = "ShCarDto", description = "三环系统-车辆信息表")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ShCarDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "seq")
    @TableId("SEQUENCE_NBR")
    private String sequenceNbr;

    @ApiModelProperty(value = "登记机关")
    @TableField("REGISTRATION_AGENCY")
    private String registrationAgency;

    @ApiModelProperty(value = "登记机关代码")
    @TableField("REGISTRATION_AGENCY_CODE")
    private String registrationAgencyCode;

    @ApiModelProperty(value = "使用登记证代码")
    @TableField("USE_REGISTRATION_CODE")
    private String useRegistrationCode;

    @ApiModelProperty(value = "气瓶安装日期")
    @TableField("INSTALL_START_DATE")
    private Date installStartDate;

    @ApiModelProperty(value = "车辆属性 A 代表 私家车  B代表公交车  C代表快捷货运  H 代表营运车  P代表公务车  V 代表微型货运车 X代表 其他   T代表出租车 J代表教练车 ")
    @TableField("VEHICLE_ATTRIBUTE")
    private String vehicleAttribute;

    @ApiModelProperty(value = "车牌号")
    @TableField("CAR_NUMBER")
    private String carNumber;

    @ApiModelProperty(value = "车架号")
    @TableField("FRAME_NUMBER")
    private String frameNumber;

    @ApiModelProperty(value = "登记日期")
    @TableField("REG_DATE")
    private Date regDate;

    @ApiModelProperty(value = "停用日期")
    @TableField("DEA_DATE")
    private Date deaDate;

    @ApiModelProperty(value = "发动机号")
    @TableField("ENGINE_NUMBER")
    private String engineNumber;

    @ApiModelProperty(value = "气瓶数量")
    @TableField("BATCH_QUANTITY")
    private Integer batchQuantity;

    @ApiModelProperty(value = "车辆品牌型号")
    @TableField("VEHICLE_BRAND_MODEL")
    private String vehicleBrandModel;

    @ApiModelProperty(value = "证打印标识")
    @TableField("CERTIFICATE_PRINT_FLAG")
    private String certificatePrintFlag;

    @ApiModelProperty(value = "联系人")
    @TableField("CONTACT_PERSON")
    private String contactPerson;

    @ApiModelProperty(value = "联系电话")
    @TableField("CONTACT_PHONE")
    private String contactPhone;

    @ApiModelProperty(value = "所有人")
    @TableField("OWNER")
    private String owner;

    @ApiModelProperty(value = "安装单位")
    @TableField("INSTALLATION_UNIT")
    private String installationUnit;

    @ApiModelProperty(value = "改装车是否打印备案通知单 原装车 忽略看")
    @TableField("IF_FLAG")
    private String ifFlag;

    @ApiModelProperty(value = "第一次打印证日期")
    @TableField("PRINT_DATE")
    private Date printDate;

    @ApiModelProperty(value = "充装介质")
    @TableField("MEDIA")
    private String media;

    @ApiModelProperty(value = "最新检验报告编号")
    @TableField("LAST_INSPECT_REPORT_NO")
    private String lastInspectReportNo;

    @ApiModelProperty(value = "气瓶状态 0正常 1变更  2报废  3注销  4启用 5停用  6注销")
    @TableField("STATE")
    private Integer state;

    @ApiModelProperty(value = "登记单位")
    @TableField("REG_UNIT")
    private String regUnit;

    @ApiModelProperty(value = "总容积")
    @TableField("TOTAL_VOLUME")
    private String totalVolume;

    @ApiModelProperty(value = "监检/检验单位")
    @TableField("INSPECTION_UNIT")
    private String inspectionUnit;

    @ApiModelProperty(value = "气瓶加装方式")
    @TableField("CYLINDER_INSTALLATION_METHOD")
    private String cylinderInstallationMethod;

    @ApiModelProperty(value = "住址")
    @TableField("ADDRESS")
    private String address;

    @ApiModelProperty(value = "上一次检验报告编号")
    @TableField("PREVIOUS_INSPECTION_REPORT_NUMBER")
    private String previousInspectionReportNumber;

    @ApiModelProperty(value = "是否认领 1已认领 0未认领")
    @TableField("CLAIMED_FLAG")
    private String claimedFlag;

    @ApiModelProperty(value = "登记证管理表的seq")
    @TableField(exist = false)
    private String certificateSeq;

    @ApiModelProperty(value = "单位类型，个人、企业")
    @TableField(exist = false)
    private String companyType;

    @ApiModelProperty(value = "使用单位名称")
    @TableField(exist = false)
    private String useUnitName;

    @ApiModelProperty(value = "使用单位统一社会信用代码")
    @TableField(exist = false)
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位地址")
    @TableField(exist = false)
    private String useUnitAddress;

    @ApiModelProperty(value = "安全管理员")
    @TableField(exist = false)
    private String safetyManagerId;

    @ApiModelProperty(value = "安全管理员联系电话")
    @TableField(exist = false)
    private String phone;


}
