package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EquipmentBizServiceImpl;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EquipmentStaticsServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/dp/equipment")
@Api(tags = "大屏-设备统计")
public class EquipmentStatisticsController {

    @Autowired
    private EquipmentStaticsServiceImpl equipmentStaticsService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "设备常规下钻图表", notes = "设备常规下钻图表")
    @PostMapping(value = "/normalChart")
    public ResponseModel<Map<String, Object>> normalChart(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(equipmentStaticsService.normalChart(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "设备常规下钻列表", notes = "设备常规下钻列表")
    @PostMapping(value = "/normalPage")
    public ResponseModel<Page<Map<String, Object>>> normalPage(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamDto, BindingResult result,
                                                                       @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                       @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(equipmentStaticsService.normalPage(current,size,dpFilterParamDto));
    }
}
