package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 管道工程装置表
 *
 * @author system_generator
 * @date 2024-12-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IdxBizJgProjectContraptionDto", description = "管道工程装置表")
public class IdxBizJgProjectContraptionDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "工程装置名称")
    private String projectContraption;

    @ApiModelProperty(value = "工程装置编号")
    private String projectContraptionNo;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitName;

    @ApiModelProperty(value = "施工单位统一信用代码")
    private String uscUnitCreditCode;

    @ApiModelProperty(value = "施工单位名称")
    private String uscUnitName;

    @ApiModelProperty(value = "设备种类代码")
    private String equListCode;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别代码")
    private String equCategoryCode;

    @ApiModelProperty(value = "设备代码")
    private String equCategory;

    @ApiModelProperty(value = "设备品种代码")
    private String equDefineCode;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备汇总表信息")
    private String content;

    @ApiModelProperty(value = "装置管道总长度(m)")
    private Double pipelineLength;

    @ApiModelProperty(value = "产品照片附件")
    private JSONArray productPhoto;

    @ApiModelProperty(value = "其他附件")
    private JSONArray otherAccessories;

    @ApiModelProperty(value = "其他附件")
    private JSONArray proOtherAccessories;


    @ApiModelProperty(value = "属地监管单位代码")
    private String orgCode;

    @ApiModelProperty(value = "属地监管单位名称")
    private String orgName;

    @ApiModelProperty(value = "产品质量合格证明")
    private JSONArray productQualificationCertificate;

    @ApiModelProperty(value = "使用地点代码_省")
    private String province;

    @ApiModelProperty(value = "使用地点代码_市")
    private String city;

    @ApiModelProperty(value = "使用地点代码_区（县）")
    private String county;

    @ApiModelProperty(value = "使用地点代码_街道（镇）")
    private String street;

    @ApiModelProperty(value = "使用详细地址")
    private String address;

    @ApiModelProperty(value = "使用地点_省")
    private String provinceName;

    @ApiModelProperty(value = "使用地点_市")
    private String cityName;

    @ApiModelProperty(value = "使用地点_区")
    private String countyName;

    @ApiModelProperty(value = "使用地点_街道")
    private String streetName;

    @ApiModelProperty(value = "装置起始位置")
    private String startLatitudeLongitude;

    @ApiModelProperty(value = "装置结束位置")
    private String endLatitudeLongitude;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "使用登记证编号")
    private String useRegistrationCode;

    @ApiModelProperty("是否是否纳管：true - 已纳管 false-未纳管")
    private Boolean isIntoManagement;

    @ApiModelProperty("数据来源（新增：0、导入：1、复制：复制数据的id 、jg:从监管加入的设备）")
    private String dataSource;

    @ApiModelProperty("设备代码")
    private String equCode;

    @ApiModelProperty("投入日期")
    private String useDate;

    @ApiModelProperty("工程装置父级ID（合并用）")
    private String projectContraptionParentId;

    @ApiModelProperty("是否首次合并新增")
    private Boolean isFirstMerge;

    @ApiModelProperty("最新一次管道改造的长度变化值（正值为增加，负值为减少）")
    private String pipeLengthChanged;

    @ApiModelProperty("证书打印标记")
    private String certificatePrintTag;

    @ApiModelProperty(value = "工程装置id")
    private Long projectContraptionId;

    public Long getProjectContraptionId(){
        return this.sequenceNbr;
    }
}
