package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.MaintenanceCompanyDto;
import com.yeejoin.amos.boot.module.common.biz.service.impl.MaintenanceCompanyServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;


/**
 * 维保单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@RestController
@Api(tags = "维保单位Api")
@RequestMapping(value = "/common/maintenance-company")
public class MaintenanceCompanyController extends BaseController {

    @Autowired
    MaintenanceCompanyServiceImpl maintenanceCompanyServiceImpl;

    /**
     * 新增维保单位
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增维保单位", notes = "新增维保单位")
    public ResponseModel<MaintenanceCompanyDto> save(@RequestBody MaintenanceCompanyDto model) {
        model = maintenanceCompanyServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新维保单位", notes = "根据sequenceNbr更新维保单位")
    public ResponseModel<MaintenanceCompanyDto> updateBySequenceNbrMaintenanceCompany(@RequestBody MaintenanceCompanyDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除维保单位", notes = "根据sequenceNbr删除维保单位")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个维保单位", notes = "根据sequenceNbr查询单个维保单位")
    public ResponseModel<MaintenanceCompanyDto> seleteOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "维保单位分页查询", notes = "维保单位分页查询")
    public ResponseModel<Page<MaintenanceCompanyDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam(value = "size") int size) {
        Page<MaintenanceCompanyDto> page = new Page<MaintenanceCompanyDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryForMaintenanceCompanyPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "维保单位列表全部数据查询", notes = "维保单位列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<MaintenanceCompanyDto>> selectForList() {
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryForMaintenanceCompanyList());
    }

    /**
     * 根据维保单位查询所有机场单位(不带分页)
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "queryCompany/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据维保单位查询所有机场单位(不带分页)", notes = "根据维保单位查询所有机场单位(不带分页)")
    public ResponseModel<List<Map<String, Object>>> seleteCompanys(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryOrgUsrMsg(sequenceNbr));
    }

    /**
     * 根据维保单位查询所有机场单位(带分页)
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "queryCompanyPages/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据维保单位查询所有机场单位(带分页)", notes = "根据维保单位查询所有机场单位(带分页)")
    public ResponseModel<List<Map<String, Object>>> seleteCompanyPages(@RequestParam(value = "pageNum")int pageNum,@RequestParam(value = "pageSize")int pageSize,@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryOrgUsrMsgPage(pageNum,pageSize,sequenceNbr));
    }

    /**
     *
     * 查询维保单位、业主单位信息
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询维保单位、业主单位信息", notes = "查询维保单位、业主单位信息")
    @GetMapping(value = "/companyLlist")
    public ResponseModel<List<Map<String,Object>>> selectCompanyList() {
        return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryCompanyMsg());
    }
}
