package com.yeejoin.amos.boot.module.common.api.dto;

import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 维保单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@Data
@ApiModel(value = "MaintenanceCompanyDto", description = "维保单位")
public class MaintenanceCompanyDto extends BaseDto{

	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value = "照片地址")
	private List<String> photoAddress;
	
	
	@ApiModelProperty(value = "上级单位Id")
	 private Long parentId;
	
	@ApiModelProperty(value = "instanceId")
	private Long instanceId;
	
	@ApiModelProperty(value = "生产企业名称")
	private String name;
	
	@ApiModelProperty(value = "企业曾用名")
	private String formerName;
	
	@ApiModelProperty(value = "法人代表")
	private String legalPerson;
	
	@ApiModelProperty(value = "注册资本")
	private String registeredCapital;
	
	
	@ApiModelProperty(value = "销售电话")
	private String salesTel;
	
	@ApiModelProperty(value = "服务电话")
	private String serviceTel;
	
	@ApiModelProperty(value = "企业性质")
	private String nature; 
	
	
	@ApiModelProperty(value = "国别")
	private String nation;
	
	
	@ApiModelProperty(value = "所在省份")
	private String province;
	
	
	@ApiModelProperty(value = "主要产品类型")
	private String mainProductType;
	
	
	@ApiModelProperty(value = "固定资产总值")
	private String totalFixedAssets;
	
	
	@ApiModelProperty(value = "拟制技术标准")
	private String draftingTechStandards;
	
	@ApiModelProperty(value = "总人数")
	private String totalStaff;
	
	
	@ApiModelProperty(value = "技术人员数量")
	private String technicianNumber;
	
	@ApiModelProperty(value = "生产企业类型")
	private String enterpriseType;
	
	@ApiModelProperty(value = "资质")
	private String  qualification;
	
	@ApiModelProperty(value = "历史沿革")
	private String history;
	
	@ApiModelProperty(value = "主要检测设备")
	private String mainTestEquipment;
	

	@ApiModelProperty(value = "重大研制记录")
	private String majorDevelopRecord;
	
	
	@ApiModelProperty(value = "地址")
	private String address;

	@ApiModelProperty(value = "类型（COMPANY单位，PERSON人员，DEPARTMENT部门）")
	private String type;

	@ApiModelProperty(value = "纬度")
	private String latitude;

	@ApiModelProperty(value = "经度")
	private String longitude;

	@ApiModelProperty(value = "标注/标绘坐标数组")
	private String coordinate;

	
	@ApiModelProperty(value = "备注")
	private String remark;
	

}
