package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 使用信息表
 *
 * @author system_generator
 * @date 2023-08-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_use_info")
@Group(value = "idx_biz_jg_use_info")
public class IdxBizJgUseInfo extends TzsBaseEntity implements IBaseChangeData {


    /**
     *
     */
    @TableField("\"RECORD\"")
    private String record;

    /**
     *
     */
    @TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
    @TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
    @TableField("\"USE_UNIT_CREDIT_CODE\"")
    @FieldDisplayDefine(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    /**
     *
     */
    @TableField("\"USE_UNIT_NAME\"")
    @FieldDisplayDefine(value = "使用单位名称")
    private String useUnitName;

    /**
     *
     */
    @TableField("\"ESTATE_UNIT_CREDIT_CODE\"")
    @FieldDisplayDefine(value = "产权单位统一信用代码", typeHandler = "estateUnitTypeHandler")
    private String estateUnitCreditCode;

    /**
     *
     */
    @TableField("\"ESTATE_UNIT_NAME\"")
    @FieldDisplayDefine(value = "产权单位名称")
    private String estateUnitName;

    /**
     *
     */
    @TableField("\"USE_STATE_CHANGE_DATE\"")
    private String useStateChangeDate;

    /**
     *
     */
    @TableField("\"CHANGES\"")
    private String changes;

    /**
     *
     */
    @TableField("\"USE_INNER_CODE\"")
    @FieldDisplayDefine(value = "使用内部编号")
    private String useInnerCode;

    /**
     *
     */
    @TableField("\"USE_DATE\"")
    @FieldDisplayDefine(value = "投用日期")
    private String useDate;

    /**
     *
     */
    @TableField("\"AGENT\"")
    private String agent;

    /**
     *
     */
    @TableField("\"PROVINCE\"")
    @FieldDisplayDefine(value = "省份行政区划", typeHandler = "regionCodeTypeHandler")
    private String province;

    /**
     *
     */
    @TableField("\"CITY\"")
    @FieldDisplayDefine(value = "地市行政区划", typeHandler = "regionCodeTypeHandler")
    private String city;

    /**
     *
     */
    @TableField("\"COUNTY\"")
    @FieldDisplayDefine(value = "区县行政区划", typeHandler = "regionCodeTypeHandler")
    private String county;

    /**
     *
     */
    @TableField("\"FACTORY_USE_SITE_STREET\"")
    @FieldDisplayDefine(value = "街道行政区划", typeHandler = "regionCodeTypeHandler")
    private String factoryUseSiteStreet;

    /**
     *
     */
    @TableField("\"ADDRESS\"")
    @FieldDisplayDefine(value = "详细地址")
    private String address;

    /**
     *
     */
    @TableField("\"LONGITUDE_LATITUDE\"")
    @FieldDisplayDefine(value = "经纬度", type = JSON.class)
    private String longitudeLatitude;

    /**
     *
     */
    @TableField("\"USE_PLACE\"")
    @FieldDisplayDefine(value = "使用场所", dictCode = "ADDRESS")
    private String usePlace;

    /**
     *
     */
    @TableField("\"EQU_MANAGE_DT\"")
    private String equManageDt;

    /**
     *
     */
    @TableField("\"SAFETY_MANAGE_DT\"")
    private String safetyManageDt;

    /**
     *
     */
    @FieldDisplayDefine(value = "安管理员名称")
    @TableField("\"SAFETY_MANAGER\"")
    private String safetyManager;

    /**
     *
     */
    @FieldDisplayDefine(value = "安管理员电话")
    @TableField("\"PHONE\"")
    private String phone;

    /**
     * 设备状态 @see com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum
     */
    @TableField("\"EQU_STATE\"")
    @FieldDisplayDefine(value = "设备状态")
    private String equState;

    /**
     *
     */
    @FieldDisplayDefine(value = "省份行政区划名称", isRepeatColumn = true)
    @TableField("\"PROVINCE_NAME\"")
    private String provinceName;

    /**
     *
     */
    @FieldDisplayDefine(value = "地市行政名称", isRepeatColumn = true)
    @TableField("\"CITY_NAME\"")
    private String cityName;

    /**
     *
     */
    @FieldDisplayDefine(value = "区县行政区划名称", isRepeatColumn = true)
    @TableField("\"COUNTY_NAME\"")
    private String countyName;

    /**
     *
     */
    @TableField("\"IS_NOT_ES\"")
    private String isNotEs;

    /**
     *
     */
    @TableField("\"IS_NOT_ELEV\"")
    private String isNotElev;


    /**
     * 创建时间
     */
    @TableField("\"CREATE_DATE\"")
    private Date createDate;

    /**
     * 认领时间
     */
    @TableField("\"CLAIM_DATE\"")
    private Date claimDate;

    /**
     * 数据来源（新增：0、导入：1、复制：复制数据的id 、jg:从监管加入的设备）
     */
    @TableField("\"DATA_SOURCE\"")
    private String dataSource;


    /**
     * 是否西咸
     */
    @TableField("\"IS_NOT_XIXIAN\"")
    @FieldDisplayDefine(value = "是否西咸", typeHandler = "yesOrNoTypeHandler")
    private String isNotXiXian;


    @TableField("\"STREET_NAME\"")
    @FieldDisplayDefine(value = "街道行政区划名称", isRepeatColumn = true)
    private String streetName;

    /**
     *
     */
    @TableField("\"SAFETY_MANAGER_ID\"")
    @FieldDisplayDefine(value = "安全管理员id")
    private String safetyManagerId;


    /**
     * 是否是否纳管：true - 已纳管 false-未纳管
     */
    @TableField("\"IS_INTO_MANAGEMENT\"")
    @FieldDisplayDefine(value = "是否已纳管")
    private Boolean isIntoManagement;


    /**
     * 工程装置名称（工业管道使用）
     */
    @TableField("\"PROJECT_CONTRAPTION\"")
    @FieldDisplayDefine(value = "工程装置名称（工业管道使用）", isRepeatColumn = true)
    private String projectContraption;


    /**
     * 历史设备-原使用登记证附件
     */
    @TableField("\"OLD_USE_REGISTRATION_CERTIFICATE\"")
    @FieldDisplayDefine(value = "原使用登记证附件")
    private String oldUseRegistrationCertificate;


    /**
     * 历史设备-原使用登记表附件
     */
    @TableField("\"OLD_USE_REGISTRATION_TABLE\"")
    @FieldDisplayDefine(value = "原使用登记表附件")
    private String oldUseRegistrationTable;


    /**
     * 历史设备-原登记机关
     */
    @TableField("\"O_REG_UNIT\"")
    @FieldDisplayDefine(value = "原登记机关")
    private String oRegUnit;


    /**
     * 历史设备-原登记日期
     */
    @TableField("\"O_REG_DATE\"")
    @FieldDisplayDefine(value = "原登记日期")
    private String oRegDate;


    /**
     * 工程装置ID
     */
    @TableField("\"PROJECT_CONTRAPTION_ID\"")
    @FieldDisplayDefine(value = "工程装置ID")
    private String projectContraptionId;

    /**
     * 备注
     */
    @TableField("\"REMARK\"")
    @FieldDisplayDefine(value = "备注")
    private String remark;

    /**
     * 数据质量等级
     */
    @TableField("\"DATA_QUALITY_SCORE\"")
    private Integer dataQualityScore;


    /**
     * 刷库专用字段
     */
    @TableField("\"VERSION\"")
    private String version;


    /**
     * 安改维单位code-安装告知、移交后写入，登记后清除
     */
    @TableField("\"USC_UNIT_CREDIT_CODE\"")
    private String USC_UNIT_CREDIT_CODE;

    /**
     * 安改维单位统名称-安装告知、移交后写入，登记后清除
     */
    @TableField("\"USC_UNIT_NAME\"")
    private String USC_UNIT_NAME;

    @TableField(exist = false)
    @FieldDisplayDefine(value = "接收单位code")
    private String receiveCompanyCode;
}
