package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@AllArgsConstructor
@Getter
public enum InformationManageTypeEnum {
    /**
     * 信息化管理情况枚举
     */
    TYPE_QR_CODE("1", "二维码"),
    TYPE_STAMP("2", "电子标签"),
    TYPE_OTHER("3", "其他"),
    TYPE_NO("99", "无");

    private String code;

    private String name;

    public static String getName(String code) {
        Optional<String> op = Arrays.stream(InformationManageTypeEnum.values()).filter(e -> e.getCode().equals(code)).map(InformationManageTypeEnum::getName).findFirst();
        return op.orElse("");
    }


}
