package com.yeejoin.amos.boot.module.common.api.excel;

import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;

/**
 * excel通用单元格格式类
 */
public class TemplateCellWriteHandler implements CellWriteHandler {
 
	@Override
	public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row,
			Head head, int relativeRowIndex, boolean isHead) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData,
			Cell cell, Head head, int relativeRowIndex, boolean isHead) {
		   Workbook workbooks = writeSheetHolder.getSheet().getWorkbook();
		   
		   if (0 == cell.getRowIndex()) {
		   writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), 20 * 256);
	        CellStyle cellStyle = workbooks.createCellStyle();
	        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);//居中
	        cellStyle.setAlignment(HorizontalAlignment.CENTER);
	        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);//设置前景填充样式
	        cellStyle.setFillForegroundColor(IndexedColors.ROYAL_BLUE.getIndex());//前景填充色
	        Font font1 = workbooks.createFont();//设置字体
	        font1.setBold(true);
	        font1.setColor((short)1);
	        font1.setFontHeightInPoints((short)15);
	        cellStyle.setFont(font1);
	        cell.setCellStyle(cellStyle);
		   }

		   
	}
		
	

}
