package com.yeejoin.equipmanage.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/3/13
 */
@Data
@Accessors(chain = true)
@Document(indexName = "equipmen_date", type = "eq", shards = 1, replicas = 0)
public class EquiplistSpecificBySystemESVO {

    @ApiModelProperty(value = "uuid")
    @Id
    private String id;
    @ApiModelProperty(value = "设备名")
    @Field(type = FieldType.Text)
    private String equipmentSpecificName;
    @ApiModelProperty(value = "设备id")
    @Field(type = FieldType.Long)
    private Long equipmentSpecificId;
    @ApiModelProperty(value = "系统编码")
    @Field(type = FieldType.Text)
    private String code;
    @ApiModelProperty(value = "iot编码")
    @Field(type = FieldType.Text)
    private String iotCode;
    @ApiModelProperty(value = "指标值")
    @Field(type = FieldType.Text)
    private String value;
    @ApiModelProperty(value = "指标颜色")
    @Field(type = FieldType.Text)
    private String emergencyLevelColor;
    @ApiModelProperty(value = "指标值说明")
    @Field(type = FieldType.Text)
    private String valueLabel;
    @ApiModelProperty(value = "紧急程度")
    @Field(type = FieldType.Text)
    private String emergencyLevel;
    @ApiModelProperty(value = "紧急程度描述")
    @Field(type = FieldType.Text)
    private String  emergencyLevelDescribe;
    @ApiModelProperty(value = "指标单位")
    @Field(type = FieldType.Text)
    private String unit;
    @ApiModelProperty(value = "指标名称")
    @Field(type = FieldType.Text)
    private String equipmentIndexName;
    @ApiModelProperty(value = "指标key")
    @Field(type = FieldType.Text)
    private String equipmentIndexKey;
    @ApiModelProperty(value = "是否告警")
    @Field(type = FieldType.Integer)
    private Integer isAlarm;
    @ApiModelProperty(value = "所属系统")
    @Field(type = FieldType.Text)
    private String systemId;
    @ApiModelProperty(value = "所属系统名称")
    @Field(type = FieldType.Text)
    private String systemName;
    @ApiModelProperty(value = "上报时间")
    @Field(type = FieldType.Long)
    private Long time;


}
