package com.yeejoin.equipmanage.common.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 动态表单实例表
 *
 * @author duanwei
 * @date 2021-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_dynamic_form_instance")
@ApiModel(value = "DynamicFormInstance对象", description = "动态表单实例表")
public class DynamicFormInstance extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段名")
    private String fieldName;

    @ApiModelProperty(value = "中文名")
    private String fieldLabel;

    @ApiModelProperty(value = "数据类型：文本，数字，枚举,日期")
    private String dataType;

    @ApiModelProperty(value = "分组类型(冗余字段便于查询）")
    private String groupType;

    @ApiModelProperty(value = "分组编号")
    private String groupCode;

    @ApiModelProperty(value = "字段分组id")
    private Long groupId;

    @ApiModelProperty(value = "动态配置字段的值")
    private String fieldValue;

    @ApiModelProperty(value = "设备实例id")
    private Long instanceId;

    @ApiModelProperty(value = "字段定义信息的主键")
    private Long formColumnId;

    @ApiModelProperty(value = "查询策略;全等,模糊,区间")
    private String queryStrategy;

    @ApiModelProperty(value = "创建者")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long creatorId;

    @TableField(exist = false)
    private JSONObject dataSource;

    @TableField(exist = false)
    private Boolean notNull;

    @TableField(exist = false)
    private String remark;
}
