package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author DELL
 */
@Data
@TableName("wl_form_group_column")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "wl_form_group_column对象", description = "分组表")
public class FormGroupColumn extends BaseEntity {

    @ApiModelProperty(value = "字段名")
    @TableField("field_name")
    private String fieldName;

    @ApiModelProperty(value = "中文名")
    @TableField("field_label")
    private String fieldLabel;

    @ApiModelProperty(value = "数据类型：文本，数字，枚举,日期")
    @TableField("data_type")
    private String dataType;


    @ApiModelProperty(value = "字段分组主键")
    @TableField("group_id")
    private Long groupId;

    @ApiModelProperty(value = "查询策略;全等,模糊,区间")
    @TableField("query_strategy")
    private String queryStrategy;

    @ApiModelProperty(value = "不能为空")
    @TableField("not_null")
    private Boolean notNull;

    @ApiModelProperty(value = "分组编号")
    @TableField("group_code")
    private String groupCode;

    @ApiModelProperty(value = "创建者")
    @TableField("creator_id")
    private Long creatorId;

}
