package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 信号分类量测枚举表
 *
 * @author system_generator
 * @date 2022-02-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_signal_classify")
public class SignalClassify extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
	@TableField("id")
    private Long id;

    /**
     * 量测枚举key
     */
	@TableField("type_code")
    private String typeCode;

    /**
     * 类型名称
     */
	@TableField("type_name")
    private String typeName;

    /**
     * 十六进制颜色
     */
	@TableField("emergency_level_color")
    private String emergencyLevelColor;

    /**
     * 是否删除:0-否；1-是
     */
	@TableField("is_alarm")
    private Integer isAlarm;

    /**
     * 紧急程度枚举（1：紧急，2：严重，3：轻微，4：正常，5：无效，6：备用，7：其他）
     */
	@TableField("emergency_level")
    private String emergencyLevel;

    /**
     * 紧急程度描述
     */
	@TableField("emergency_level_describe")
    private String emergencyLevelDescribe;

}
