package com.yeejoin.equipmanage.common.entity.dto;

import com.yeejoin.equipmanage.common.entity.FireFightingSystemGroupEntity;
import com.yeejoin.equipmanage.common.entity.publics.BaseDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class FireFightingSystemGroupModalDto extends BaseDTO<FireFightingSystemGroupEntity> {

    @ApiModelProperty(value = "分组名称")
    private String groupName;

    @ApiModelProperty(value = "展示类型：0-安措 1-保护区域")
    private Integer displayType;

    @ApiModelProperty(value = "分组排序")
    private Integer sort;

    @ApiModelProperty(value = "系统装备列表")
    private List<SystemEquipmentsDto> systems;

    @ApiModelProperty(value = "业务组织编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "业务组织名称")
    private String bizOrgName;
}
