package com.yeejoin.equipmanage.common.entity.vo;

import lombok.Data;
import org.typroject.tyboot.core.foundation.utils.TreeNode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author keyong
 * @date 2020/11/23 16:58
 * @since v2.0
 */
@Data
public class PageSecurityVideoVO implements TreeNode<PageSecurityVideoVO, Long> {
    private Long id;
    private Long parentId;
    private String name;
    private String fullName;
    private List<PageSecurityVideoVO> children;

    @Override
    public Long getMyParentId() {
        return parentId;
    }

    @Override
    public Long getMyId() {
        return id;
    }

    @Override
    public void setChildren(Collection<PageSecurityVideoVO> collection) {
        this.children = new ArrayList<>(collection);
    }

    @Override
    public int compareTo(PageSecurityVideoVO o) {
        return this.getId().compareTo(o.getId());
    }
}
