package com.yeejoin.equipmanage.common.enums;

public enum WarehosueLevelEnum {
	PT("1", "普通"), ZQ("2", "战勤"), TQ("3", "特勤");

	private String name;

	private String code;

	private WarehosueLevelEnum(String code, String name) {
		this.code = code;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public static WarehosueLevelEnum getEnum(String code) {
		for (WarehosueLevelEnum bEnum : WarehosueLevelEnum.values()) {
			if (bEnum.getCode().equals(code)) {
				return bEnum;
			}
		}
		return null;
	}
}
