package com.yeejoin.amos.boot.module.jcs.api.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrganizationExportDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrganizationUserExportDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Organization;

import java.util.List;
import java.util.Map;


public interface OrganizationService {

    Page<Map<String, Object>> getOrganizationInfo(Page<Map<String, Object>> page, String bizOrgCode);

    Page<Map<String, Object>> getOrganizationList(Page<Map<String, Object>> page, String bizOrgCode);

    List<OrganizationExportDto> selectOrganization(String bizOrgCode);

    List<OrganizationUserExportDto> selectOrganizationUserList(String bizOrgCode);

    void saveOrganization(List<OrganizationExportDto> data, List<OrganizationUserExportDto> userData, String bizOrgCode);

    /**
     * 保存应急小组
     * @param organization
     * @return
     */
    Organization saveOrganization(Organization organization);

    Organization updateModelById(Organization organization);


    boolean moveTeam(String method, Long id);

    List<Organization> getList();

    Organization getDetailsById(Long id);

    int deleteById(Long id);

    Map<String, Object> getSystemOnlineDate(String orgCode);

}
