package com.yeejoin.amos.kgd.message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.typroject.tyboot.component.emq.EmqKeeper;

@Configuration
public class MessageConfig  implements ApplicationListener<ApplicationReadyEvent>{
    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    IOTPropertyMessageAction propertyMessageAction;
    @Autowired
    MaasMessageAction maasMessageAction;

    @Value("spring.application.name")
    private String serviceName;

    public static final Integer DEFAULT_QOS = 2;

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
             emqKeeper.subscript(Topic.IOT_PROPERTY_MESSAGE.getShareTopicStr(serviceName), DEFAULT_QOS, propertyMessageAction);
             emqKeeper.subscript(Topic.MAAS_CALCULATION_RESULTS.getShareTopicStr(serviceName), DEFAULT_QOS, maasMessageAction);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
