package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 企业资质信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_company_qualifications")
@ApiModel(value = "CompanyQualifications对象", description = "企业资质信息")
public class CompanyQualifications extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "公司id")
    private Long companyId;
    @ApiModelProperty(value = "证书名称")
    private String certificateName;
    @ApiModelProperty(value = "证书编号")
    private String certificateNumber;
    @ApiModelProperty(value = "有效期至")
    private Date expireToDate;
    @ApiModelProperty(value = "发证机关")
    private String issuingAuthority;

    @ApiModelProperty(value = "顺序")
    private Long orders;


    @ApiModelProperty(value = "证书图片")
    @ImagePrefix
    private String certificateImg;
    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    @ImagePrefix
    private List<CompanyQualificationsAttachment> attachment;
}
