package com.yeejoin.precontrol.common.feign;

import com.yeejoin.precontrol.common.dto.feign.CreateIntegralDto;
import com.yeejoin.precontrol.common.feign.fallback.CustomUserServiceFallback;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@FeignClient(name = "AMOS-INTEGRAL", configuration = { IntegralFeign.Configuration.class,FeignRequestInterceptor.class }, fallback = CustomUserServiceFallback.class)
//@FeignClient(name = "AMOS-INTEGRAL", configuration = { IntegralFeign.Configuration.class,FeignRequestInterceptor.class }, fallback = CustomUserServiceFallback.class, url = "http://39.100.239.237:8106")
//@FeignClient(name = "AMOS-INTEGRAL", configuration = { IntegralFeign.Configuration.class,FeignRequestInterceptor.class }, fallback = CustomUserServiceFallback.class, url = "http://47.92.234.253:8106")
//@FeignClient(name = "AMOS-INTEGRAL", configuration = { IntegralFeign.Configuration.class,FeignRequestInterceptor.class }, fallback = CustomUserServiceFallback.class, url = "http://localhost:8106")
public interface IntegralFeign {

	@RequestMapping(value = "/integral/integral-record/save", method = RequestMethod.POST)
	ResponseModel<Double> save(@RequestBody CreateIntegralDto createIntegralDto);

	@RequestMapping(value = "/integral/integral-record/user-integral-sum/{userId}", method = RequestMethod.GET)
	ResponseModel<Double> getPersonIntegral(@PathVariable("userId") Long userId);

	@RequestMapping(value = "/integral/integral-record/user-details-page", method = RequestMethod.GET)
	ResponseModel<Object> getIntegralPage(@RequestParam("userId") Long userId, @RequestParam("current") Integer current,
			@RequestParam("size") Integer size);
	
	@RequestMapping(value = "/integral/integral-record/userIds", method = RequestMethod.DELETE)
	ResponseModel<Object> deleteByUserIds(@RequestBody List<Long> userIds);

	class Configuration {
		@Bean
		Encoder feignFormEncoder(ObjectFactory<HttpMessageConverters> converters) {
			return new SpringFormEncoder(new SpringEncoder(converters));
		}
	}
}
