package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.PersonClock;
import com.yeejoin.precontrol.common.entity.publics.CommonPageable;
import com.yeejoin.precontrol.common.vo.PersonClockVo;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 人员履历信息(打卡) 服务类
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface IPersonClockService extends IService<PersonClock> {

	/**
	 * 人员履历分页查询
	 * 
	 * @param pageable
	 * @param param
	 * @return
	 */
	Page pageInfo(CommonPageable pageable, HashMap<String, Object> param);

	/**
	 * 对接三合闸机人员出入场打卡
	 * 
	 * @param PersonClockVo
	 * @return ResponseModel
	 */
	ResponseModel personClock(PersonClockVo PersonClockVo);

	/**
	 * 对接闸机生成数字签名
	 * 
	 * @param deviceNo
	 * @return ResponseModel
	 */
	ResponseModel getSignature(String deviceNo);

	List<PersonClock> getEveryDayMaxList(Long personId, Date startTime, Date endTime);

	List<PersonClock> getEveryDayMinList(Long personId, Date startTime, Date endTime);

	IPage<PersonClockVo> listByDevice(StudioPageableDto pageable, PersonClockVo personClockVo);
}
