package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.RewardExchange;
import com.yeejoin.precontrol.common.vo.RewardExchangeVo;
import com.yeejoin.precontrol.common.vo.RewardExchangeWechatVo;

import java.util.List;

/**
 * 奖励兑换 服务接口
 * @author wbin
 * @date 2021-04-06
 */
public interface IRewardExchangeService extends IService<RewardExchange> {

    boolean saveExchange(RewardExchangeVo rewardExchangeVo);

    /**
     * 查询在该日期区间的兑换记录
     * @param startDate 开始日期
     * @param endDate 结束前日期
     * @param personId 用户id
     * @return
     */
    List<RewardExchange> reportByUserIdAndBetweenDate(String startDate, String endDate, Long personId);

    /**
     * 选择日期的奖励兑换详情
     * @param date
     * @return
     */
    List<RewardExchangeWechatVo> selectByDate(String date, Long personId);

    /**
     * 已兑换总金额
     * @param personId 
     * @return
     */
    String selectTotalMoney(Long personId);
    
    IPage<RewardExchangeWechatVo> exchangeRecord(StudioPageableDto pageable,Long personId);
}
