package com.yeejoin.precontrol.common.task;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.entity.TaskRiskControl;
import com.yeejoin.precontrol.common.enums.TaskCurrentStatusEnum;
import com.yeejoin.precontrol.common.enums.TaskTypeEnum;
import com.yeejoin.precontrol.common.service.ITaskRiskControlService;
import com.yeejoin.precontrol.common.service.ITaskService;
import com.yeejoin.precontrol.common.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/**
 * @description: 安全施工任务当前状态计算
 * @author: duanwei
 * @date: 2020-08-07 14:06
 **/

@Component
@EnableScheduling
@Slf4j
@Service
public class TaskSafeConstructionTask {

	@Autowired
	ITaskService iTaskService;

	@Autowired
	ITaskRiskControlService iTaskRiskControlService;

	/**
	 * 每15分钟计算一次
	 */
	@Scheduled(cron = "0 0 0/1 * * ?")
	public void scan() throws ParseException {
		log.info("定时任务安全施工任务当前状态计算开始--------------->");
		// 年月日时分秒格式化
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//        Date currentDate = new Date();
//        String day = sdf.format(currentDate);
		// 日历
		Calendar calendar = new GregorianCalendar();
		// 取出所有未完成的任务 实时更新当前状态
		List<Task> taskList = iTaskService.list(new LambdaQueryWrapper<Task>().notIn(Task::getStatus, 1)
				.notIn(Task::getCurrentStatus, TaskCurrentStatusEnum.UNCOMPLETE.getLongValue()));
		for (Task task : taskList) {
			Date createDate = task.getCreateDate();
//            String taskDay = sdf.format(createDate);
//            if (day.equals(taskDay)) {
//                //是同一天的任务 只存在两种情况 进行中和超时 大于2小时就超时
//                long currentDateTime = currentDate.getTime();
//                long taskTime = createDate.getTime();
//                if ((currentDateTime - taskTime) / 1000.0 / 3600.0 >= 2) {
//                    //超出2小时 小于当天 设置为超时状态
//                    if (task.getCurrentStatus() != 1) {
//                        task.setCurrentStatus(1L);
//                        iTaskService.updateById(task);
//                    }
//                }
//            } else {
//                //不是同一天的任务 判定为未完成 现在以一天为标准
//                //多层转换 得到任务增加一天之后的时间戳
//                calendar.setTime(createDate);
//                calendar.add(Calendar.DAY_OF_MONTH, 1);
//                Date addTaskDate = calendar.getTime();
//                String addTaskDateFormat = sdf.format(addTaskDate);
//                Date taskDate = DateUtils.dateParse(addTaskDateFormat, DateUtils.DATE_TIME_PATTERN);
//                if (currentDate.getTime() >= taskDate.getTime()) {
//                    //超出1天 设置为未完成状态
//                    if (task.getCurrentStatus() != 2) {
//                        task.setCurrentStatus(2L);
//                        iTaskService.updateById(task);
//                    }
//                }
//                //else 情况则 表示 当前任务加1天 比当前时间小 但这种情况不存在的 这里的写法 主要用来控制未完成的时间 防止以后改需求
//            }
			// 薪资任务相差3天改成未完成 其他任务相差1天改成未完成
			int betweenDays = DateUtils.dateBetween(createDate, new Date());
			if (task.getType() == TaskTypeEnum.SALARY_CONFIRM.getValue()) {
				if (betweenDays >= 3) {
					task.setCurrentStatus(TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
					iTaskService.updateById(task);
				}
			} else if (task.getType() == TaskTypeEnum.RISK.getValue()) {
				TaskRiskControl taskRiskControl = iTaskRiskControlService
						.getOne(new LambdaQueryWrapper<TaskRiskControl>().eq(TaskRiskControl::getTaskId, task.getId()));
				if(taskRiskControl !=null) 
				{
					int betweenDays2 = DateUtils.dateBetween(taskRiskControl.getEndTime(), new Date());
					if (betweenDays2 > 0) {
						log.error("====task over time====:" + JSONObject.toJSONString(taskRiskControl));
						log.error("====now time====:" + new Date());
						task.setCurrentStatus(TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
						iTaskService.updateById(task);
					}
				}
			} else {
				if (betweenDays >= 1) {
					task.setCurrentStatus(TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
					iTaskService.updateById(task);
				}
			}
		}
		log.info("定时任务安全施工任务当前状态计算结束--------------->");
	}

}
