package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import lombok.Data;

import java.util.List;
import java.util.Objects;

/**
 * @author shg
 */
@Data
public class RiskWorkPersonVo {
    private Long id;
    private String userId;
    private String userName;
    private String roleName;

    @ImagePrefix
    private String headPhoto;
    private String companyName;
    private String departmentName;
    private String certificateNameKey;
    private Long companyId;
    private Long projectId;

    private String postNameKey;
    private String postName;
    private String workTypeKey;
    
    List<RiskWorkRequestVo> requestList;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RiskWorkPersonVo that = (RiskWorkPersonVo) o;
        return Objects.equals(userId, that.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId);
    }
}
