package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireEquipmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;

/**
 * 消防设备资产
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防设备资产Api")
@RequestMapping(value = "/fire-equipment")
public class FireEquipmentController extends BaseController {

    @Autowired
    IFireEquipmentService iFireEquipmentService;

    /**
     * 物联接入汇总
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "物联接入汇总", notes = "物联接入汇总")
    @GetMapping(value = "/iot/count")
    public ResponseModel selectForMonitorCount(
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode) throws ParseException {
        return ResponseHelper.buildResponse(iFireEquipmentService.selectForMonitorCount(stationCode));
    }


    /**
     * 站端物联设备
     *
     * @param stationCode 换流站code
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "站端物联设备", notes = "站端物联设备")
    @GetMapping(value = "/station/info")
    public ResponseModel stationEquipmentInfo(
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode,
            @ApiParam(value = "换流站名称") @RequestParam(required = false) String stationName) {
        return ResponseHelper.buildResponse(iFireEquipmentService.stationEquipmentInfo(stationCode,stationName));
    }


    /**
     * 故障设备top
     *
     * @param top 页面展示上限条数
     * @return List
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "故障设备top", notes = "故障设备top")
    @GetMapping(value = "/count/fault/list")
    public ResponseModel faultEquipTop(
            @ApiParam(value = "页面展示上限条数") @RequestParam(required = false) Long top) {
        return ResponseHelper.buildResponse(iFireEquipmentService.faultEquipTopCount(top));
    }
}
