package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireSignalDayStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;

/**
 * 换流站告警日统计
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "换流站告警日统计Api")
@RequestMapping(value = "/fire-signal-day-statistics")
public class FireSignalDayStatisticsController extends BaseController {

    @Autowired
    FireSignalDayStatisticsServiceImpl fireSignalDayStatisticsServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "警情信息统计", notes = "警情信息统计")
    @GetMapping(value = "/alarm/count")
    public ResponseModel selectForAlarmCount() throws ParseException {
        return ResponseHelper.buildResponse(fireSignalDayStatisticsServiceImpl.selectForAlarmCount());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "警情变化趋势", notes = "警情变化趋势")
    @GetMapping(value = "/alarm/trend")
    public ResponseModel selectForAlarmTrend(
            @ApiParam(value = "开始日期：yyyy-MM-dd", required = true) @RequestParam String beginData,
            @ApiParam(value = "结束日期：yyyy-MM-dd", required = true) @RequestParam String endData) {
        return ResponseHelper.buildResponse(fireSignalDayStatisticsServiceImpl.selectForAlarmTrend(beginData, endData));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "警情类型占比", notes = "警情类型占比")
    @GetMapping(value = "/alarm/percent")
    public ResponseModel todayAlarmPercent(
            @ApiParam(value = "开始日期：yyyy-MM-dd", required = true) @RequestParam String beginData,
            @ApiParam(value = "结束日期：yyyy-MM-dd", required = true) @RequestParam String endData) {
        return ResponseHelper.buildResponse(fireSignalDayStatisticsServiceImpl.todayAlarmPercent(beginData, endData));
    }
}
