package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireLatentDangerDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireLatentDanger;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireLatentDangerMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireLatentDangerService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 隐患信息服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireLatentDangerServiceImpl extends BaseService<FireLatentDangerDto, FireLatentDanger, FireLatentDangerMapper> implements IFireLatentDangerService {
    /**
     * 分页查询
     */
    public Page<FireLatentDangerDto> queryForFireLatentDangerPage(Page<FireLatentDangerDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     *
     * @param top         取值
     * @param stationCode 站code
     */
    public List<FireLatentDangerDto> queryForFireLatentDangerList(Long top, String stationCode) {
        return this.baseMapper.queryDangerList(top, stationCode);
    }

    public Map<String, Object> dangerStateGroupMap(String stationCode) {
        List<Map<String, Object>> list = this.baseMapper.dangerStateGroupMap(stationCode);
        Map<String, Object> result = new LinkedHashMap<>();
        list.forEach(m -> {
            result.put(m.get("dangerState").toString(), m.get("num"));
        });
        return result;
    }
}