package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IEquipmentSpecificIndexSerivce;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@Api(tags = "装备性能指标API")
@RequestMapping(value = "/equipSpecificIndex")
public class EquipmentSpecificIndexController extends AbstractBaseController {

    @Autowired
    private IEquipmentSpecificIndexSerivce equipmentSpecificIndexService;

    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取性能指标", notes = "获取性能指标")
    public EquipmentSpecificIndex getEquipSpecificIndexDetail(@RequestParam("id") String id) {
        return equipmentSpecificIndexService.getById(id);
    }

    @RequestMapping(value = "/page", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取性能指标", notes = "获取性能指标")
    public IPage<Map<String, Object>> getPage(
            @RequestParam(value = "pageNumber", required = false) Integer pageNumber,
            @RequestParam(value = "pageSize", required = false) Integer pageSize,
            @RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
            @RequestParam(value = "systemId", required = false) String systemId,
            @RequestParam(value = "equipName", required = false) String equipName,
            @RequestParam(value = "startDate", required = false) String startDate,
            @RequestParam(value = "endDate", required = false) String endDate
    ) {
        if (!StringUtils.hasText(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        Page<EquipmentSpecificIndex> page = new Page<>(pageNumber, pageSize);
        return equipmentSpecificIndexService.getPage(page, bizOrgCode, systemId, equipName, startDate, endDate);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getIndexByCode")
    @ApiOperation(httpMethod = "GET", value = "指标", notes = "指标")
    public ResponseModel getIndexByCode(@RequestParam String indexs, @RequestParam(required = false) String bizOrgCode) {
        return CommonResponseUtil.success(equipmentSpecificIndexService.getIndexDataByIndex(indexs, bizOrgCode));
    }

}
