package com.yeejoin.equipmanage.operation.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.enums.GroupTypeEnum;
import com.yeejoin.equipmanage.context.SpringContextHolder;
import com.yeejoin.equipmanage.operation.PageOperation;
import com.yeejoin.equipmanage.service.IBuilldService;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import com.yeejoin.equipmanage.service.impl.BuildingServiceImpl;
import com.yeejoin.equipmanage.service.impl.FormInstanceServiceImpl;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Map;

/**
 * @Author: songLei
 * @Description: groupType是building的时候分页器
 * @Date: 2020/12/23 10:37
 * @Version: 1.0
 */
public class BuildFloorPage implements PageOperation {
    @Override
    public Page apply(Page page, BuildSearchDTO dto) {
        IFormInstanceService formInstanceService = SpringContextHolder.getBean(FormInstanceServiceImpl.class);
        IBuilldService builldService = SpringContextHolder.getBean(BuildingServiceImpl.class);
        Page pageData = formInstanceService.queryPage(page, dto);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().parallelStream().forEach(instanceId -> {
                Map<String, Object> instanceIdMap = (Map<String, Object>) instanceId;
                instanceIdMap.put("equipmentTotal", builldService.getEveryCount(
                        Long.parseLong(String.valueOf(instanceIdMap.get("instanceId"))),
                        GroupTypeEnum.FLOOR.getType(), "").get("equipCount"));
                builldService.sourceBuild(instanceIdMap);
            });
        }
        return pageData;
    }
}
