package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.FormInstanceEquip;
import com.yeejoin.equipmanage.common.entity.dto.FormGroupColumnEquipDto;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IFormInstanceEquipService extends IService<FormInstanceEquip> {

    List<FormGroupColumnEquipDto> queryColumnAndValueByGroup(String groupCode, Long instanceId);

    /**
     * 通用表单保存
     *
     * @param groupCode   表单类型
     * @param orgCode 公司编号
     * @param map         form
     * @param caseId 实例ID
     * @return Object
     */
    Object saveForm(String groupCode, String orgCode, Map<String, Object> map, String instanceId);

    /**
     * 创建
     *
     * @param groupCode   分类
     * @param companyCode 公司编码
     * @param map         字段值对象
     * @return Map<String, Object>
     */
    Map<String, Object> createByMap(String groupCode, String companyCode, Map<String, Object> map, String caseId);

    /**
     * 通用表单更新
     *
     * @param instanceId 实例id
     * @param companyCode 公司编号
     * @param map         form
     * @return Object
     */
    Object updateForm(Long instanceId, String companyCode, Map<String, Object> map, String groupCode);

    /**
     * 删除
     *
     * @param instanceId 实例id
     * @return 是否成功
     */
    Boolean deleteInstanceById(Long instanceId);
}
