package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.Warehouse;
import com.yeejoin.equipmanage.common.entity.WarehouseStructure;

import java.util.List;

/**
 * 货架结构 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IWarehouseStructureService extends IService<WarehouseStructure> {

	WarehouseStructure saveOne(WarehouseStructure warehouseStructure);

	List<WarehouseStructure> tree(Long warehouseId);

	List<WarehouseStructure> gettree(Long warehouseId, String bizOrgCode, String buildingId);

	//如果是部门向上查询本单位下建筑
	List<WarehouseStructure> gettreeToPrent(Long warehouseId, String bizOrgCode);

	WarehouseStructure updateOneById(WarehouseStructure warehouseStructure);

	boolean removeOneById(Long id) throws Exception;

	boolean removeBatchById(List<Long> idList) throws Exception;
	
	/**
	 * 
	 * 远程同步新增修改货架信息
	 *
	 * @param source 源数据
	 * @param w 仓库数据
	 * @return String
	 * @throws <br>
	 * @author 张展弋
	 * @date 2020-9-8 18:34:10
	 */
	String doSaveAutoSysSyn(Warehouse source,Warehouse w);
	

	/**
	 * 
	 * 远程同步删除货架信息  
	 *
	 * @param sourceId
	 * @return String
	 * @throws <br>
	 * @author 张展弋
	 * @date 2020-9-9 10:02:13
	 */
    public String deleteAutoSysSyn(Long sourceId);

}
