package com.yeejoin.equipmanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.equipmanage.common.entity.Alarm;
import com.yeejoin.equipmanage.common.vo.EquipmentAlarmDownloadVO;
import com.yeejoin.equipmanage.dto.AlarmExportDto;
import com.yeejoin.equipmanage.mapper.AlarmMapper;
import com.yeejoin.equipmanage.mapper.EmergencyMapper;
import com.yeejoin.equipmanage.service.IAlarmService;
import liquibase.pro.packaged.L;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *  服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class AlarmServiceImpl extends ServiceImpl<AlarmMapper, Alarm> implements IAlarmService {

    @Autowired
    AlarmMapper  alarmMapper;

    @Autowired
    EmergencyMapper emergencyMapper;

    @Override
    public void downList(HttpServletResponse response, String bizOrgCode, String systemCode, List<String> types, List<String> emergencyLevels, String name, Integer cleanStatus, Integer handleStatus, String createDate, String startDate, String endDate) {
        List<Map<String, Object>> list = emergencyMapper.alarmListNoPage(bizOrgCode, systemCode, types, emergencyLevels, name, cleanStatus, handleStatus, createDate, startDate, endDate);
        List<AlarmExportDto> alarmExportDtoList = new ArrayList<>();
        if(list.size() > 0) {
            for (Map m :list
                 ) {
                String s = JSONObject.toJSONString(m);
                AlarmExportDto dto = JSONObject.parseObject(s, AlarmExportDto.class);
                alarmExportDtoList.add(dto);
            }
            ExcelUtil.createTemplate(response, "设备告警信息", "设备告警信息", alarmExportDtoList, AlarmExportDto.class, null, false);
        }
    }

    @Override
    public List<Map<String,String>> totalNum(String bizOrgCode, String systemId) {
        return alarmMapper.totalNum(bizOrgCode, systemId);
    }

}
