package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.repository.ITopographyLineDao;
import com.yeejoin.amos.fas.business.dao.repository.ITopographyNodeDao;
import com.yeejoin.amos.fas.business.dao.repository.ITopographyNodeDetailDao;
import com.yeejoin.amos.fas.business.service.intfc.ITopographyNodeService;
import com.yeejoin.amos.fas.dao.entity.TopographyLine;
import com.yeejoin.amos.fas.dao.entity.TopographyNode;
import com.yeejoin.amos.fas.dao.entity.TopographyNodeDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("topographyNodeService")
public class ITopographyNodeServiceImpl implements ITopographyNodeService{
	
	@Autowired
	private ITopographyNodeDao nodeDao;
	
	@Autowired
	private ITopographyNodeDetailDao nodeDetailDao;
	
	@Autowired
	private ITopographyLineDao lineDao;

	@Override
	public List<TopographyNode> getNodesByAppIdAndType(String appId,String type) {
		if(appId == null) {
			return nodeDao.findByType(type);
		}
		return nodeDao.findByAppIdAndType(appId,type);
	}

	@Override
	public void saveNodes(List<TopographyNode> nodeData) {
		nodeDao.saveAll(nodeData);
	}

	@Override
	public TopographyNodeDetail getNodeDetailById(String nodeid) {
		return nodeDetailDao.findByNodeid(nodeid);
	}

	@Override
	public TopographyNodeDetail saveNodeDetail(TopographyNodeDetail nodeDetail) {
		TopographyNodeDetail curNodeDetail = nodeDetailDao.findByNodeid(nodeDetail.getNodeid());
		if(curNodeDetail == null) {
			curNodeDetail = new TopographyNodeDetail();
			curNodeDetail.setNodeid(nodeDetail.getNodeid());
		}
		curNodeDetail.setNodeDetail(nodeDetail.getNodeDetail());
		TopographyNodeDetail save = nodeDetailDao.save(curNodeDetail);
		return save;
	}

	@Override
	public void deleteNode(TopographyNode node) {
//		TopographyNode node = nodeDao.findById(id);
		if(node != null) {
			String key = node.getKey();
			nodeDao.delete(node);
			List<TopographyLine> lines = lineDao.findByKey(key);
			if(lines != null && lines.size() > 0) {
				lineDao.deleteAll(lines);
			}
			if(node.getIsGroup() != null && node.getIsGroup()) {
				List<TopographyNode> childNodes = nodeDao.findByGroupAndAppIdAndType(node.getKey(),node.getAppId(),node.getType());
				childNodes.forEach(c -> deleteNode(c));
			}
			return;
		}
	}

	@Override
	public TopographyNode queryByKeyAndAppIdAndType(String nodekey, String appId,String type) {
		return nodeDao.findByKeyAndAppIdAndType(nodekey,appId,type);
	}

	@Override
	public int queryMaxKeyByAppIdAndType(String appId,String type) {
		Integer maxKey;
		if(null == appId) {
			maxKey = nodeDao.queryMaxKeyByType(type);		
		}else {
			maxKey = nodeDao.queryMaxKeyByAppIdAndType(appId,type);			
		}
		if(maxKey == null) {
			maxKey = 0;
		}
		return maxKey;
	}

	@Override
	public TopographyNode queryById(String id) {
		return nodeDao.findById(id);
	}

	@Override
	public List<TopographyNode> getNodesByType(String type) {
		return nodeDao.findByType(type);
	}


}
